/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.impl.unmarshaller;

import com.vmware.vim.vmomi.core.exception.UnmarshallException;
import com.vmware.vim.vmomi.core.soap.Constants;
import com.vmware.vim.vmomi.server.DeserializedRequest;
import com.vmware.vim.vmomi.server.Dispatcher;
import com.vmware.vim.vmomi.server.impl.unmarshaller.BodyStackContext;
import com.vmware.vim.vmomi.server.impl.unmarshaller.HeaderStackContext;
import com.vmware.vim.vmomi.server.impl.unmarshaller.StackContext;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;

public class EnvelopeStackContext
extends StackContext {
    private final Dispatcher _dispatcher;
    private final String _soapAction;
    private final XMLStreamReader _input;
    private HeaderStackContext _header;
    private BodyStackContext _body;

    public EnvelopeStackContext(Dispatcher dispatcher, String soapAction, XMLStreamReader input) {
        this._dispatcher = dispatcher;
        this._soapAction = soapAction;
        this._input = input;
    }

    @Override
    public StackContext getNestedContext(QName name, Map<QName, String> attrs) throws UnmarshallException {
        if (name.equals(Constants.HEADER_QNAME)) {
            this._header = new HeaderStackContext();
            return this._header;
        }
        if (name.equals(Constants.BODY_QNAME)) {
            this._body = new BodyStackContext(this);
            return this._body;
        }
        throw new UnmarshallException(String.format("Request envelope contains invalid element '%1$s'", name));
    }

    public HeaderStackContext getHeader() {
        return this._header;
    }

    public BodyStackContext getBody() {
        return this._body;
    }

    public Dispatcher getDispatcher() {
        return this._dispatcher;
    }

    public XMLStreamReader getInput() {
        return this._input;
    }

    public String getSoapAction() {
        return this._soapAction;
    }

    public DeserializedRequest getDeserializedRequest() throws UnmarshallException {
        DeserializedRequest deserializedRequest = this._body.getMethod().getDeserializedRequest();
        if (null != this._header) {
            this._header.updateDeserializedRequest(deserializedRequest);
        }
        return deserializedRequest;
    }

    public String getEnvelopeVersion(String namespaceURI) {
        QName versionUriQName;
        StackContext versionContext;
        String envelopeVersion = null;
        if (this._header != null && (versionContext = this._header.getChild(versionUriQName = new QName(namespaceURI, "versionURI"))) != null) {
            envelopeVersion = versionContext.getValue();
        }
        return envelopeVersion;
    }
}

