/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.impl.unmarshaller;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.exception.UnmarshallException;
import com.vmware.vim.vmomi.core.types.ManagedMethod;
import com.vmware.vim.vmomi.core.types.ManagedObjectType;
import com.vmware.vim.vmomi.core.types.ManagedProperty;
import com.vmware.vim.vmomi.core.types.VmodlField;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import com.vmware.vim.vmomi.server.BodyHandler;
import com.vmware.vim.vmomi.server.DeserializedRequest;
import com.vmware.vim.vmomi.server.SoapBinding;
import com.vmware.vim.vmomi.server.exception.UnsupportedVersionException;
import com.vmware.vim.vmomi.server.impl.unmarshaller.BodyStackContext;
import com.vmware.vim.vmomi.server.impl.unmarshaller.DeserializedRequestImpl;
import com.vmware.vim.vmomi.server.impl.unmarshaller.EnvelopeStackContext;
import com.vmware.vim.vmomi.server.impl.unmarshaller.PropertyStackContext;
import com.vmware.vim.vmomi.server.impl.unmarshaller.StackContext;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class MethodStackContext
extends StackContext {
    private String _namespaceUri;
    private String _methodName;
    private BodyHandler _bodyHandler;
    private SoapBinding _soapBinding;
    private XMLStreamReader _input;
    private ManagedObjectReference _moRef;
    private ManagedObjectType _moType;
    private ManagedMethod _managedMethod;
    private VmodlField[] _params;
    private static Object[] EMPTY_ARGS = new Object[0];
    private Object[] _args;
    private int _argIndex;

    public MethodStackContext(BodyStackContext parent, QName qName) throws UnsupportedVersionException {
        this._namespaceUri = qName.getNamespaceURI();
        this._methodName = qName.getLocalPart();
        EnvelopeStackContext envelope = parent.getEnvelope();
        this._input = envelope.getInput();
        String envelopeVersion = envelope.getEnvelopeVersion(this._namespaceUri);
        this._bodyHandler = envelope.getDispatcher().findBodyHandler(envelopeVersion, envelope.getSoapAction(), this._namespaceUri);
        this._soapBinding = this._bodyHandler.getSoapBinding();
    }

    private static Match matchFieldWithElementName(VmodlField param, String name) {
        if (name == null || !name.equals(param.getWsdlName())) {
            return param.isOptional() ? Match.SKIP : Match.MISMATCH;
        }
        return Match.MATCH;
    }

    private static ManagedMethod findManagedMethod(String wsdlName, ManagedObjectType moType, VmodlVersion version) throws UnmarshallException {
        ManagedMethod managedMethod = moType.getWsdlMethod(wsdlName);
        if (managedMethod == null || !managedMethod.isVisible(version)) {
            throw new UnmarshallException(String.format("Invalid managed method '%1$s' requested for Managed Object Type '%2$s' version '%3$s'", wsdlName, moType, version));
        }
        return managedMethod;
    }

    @Override
    public StackContext getNestedContext(QName name, Map<QName, String> attrs) throws UnmarshallException {
        VmodlField param;
        Match match;
        if (this._moRef == null) {
            if (!"_this".equals(name.getLocalPart())) {
                throw new UnmarshallException(String.format("Missing request target object (found '%1$s')", name));
            }
            this._moRef = this._soapBinding.deserializeThisField(this._input);
            this._moType = this._soapBinding.getMoType(this._moRef);
            if (this._moType == null) {
                throw new UnmarshallException(String.format("Invalid request target object type '%1$s'", this._moRef.getType()));
            }
            return null;
        }
        if ("Fetch".equals(this._methodName)) {
            if (!"prop".equals(name.getLocalPart())) {
                throw new UnmarshallException("Managed property missing from request");
            }
            return new PropertyStackContext(this);
        }
        if (this._managedMethod == null) {
            this._managedMethod = MethodStackContext.findManagedMethod(this._methodName, this._moType, this._soapBinding.getVersion());
            this._params = this._managedMethod.getParameters();
            this._args = new Object[this._params.length];
            this._argIndex = 0;
        }
        if (this._argIndex >= this._params.length) {
            throw new UnmarshallException(String.format("Too many arguments passed to managed method '%1$s'", this._managedMethod.getWsdlName()));
        }
        do {
            if ((match = MethodStackContext.matchFieldWithElementName(param = this._params[this._argIndex], name.getLocalPart())) != Match.SKIP) continue;
            ++this._argIndex;
        } while (match == Match.SKIP);
        if (match == Match.MISMATCH) {
            throw new UnmarshallException(String.format("Missing required parameter '%1$s'", param.getName()));
        }
        this._args[this._argIndex++] = this._soapBinding.deserializeParam(param, this._input);
        return null;
    }

    @Override
    public int nextParsingEvent(XMLStreamReader input) throws XMLStreamException {
        VmodlField lastParsed;
        if (this._params != null && (lastParsed = this._params[this._argIndex - 1]).getType().getKind() == VmodlType.Kind.ARRAY) {
            return this._input.getEventType();
        }
        return input.next();
    }

    public void setPropertyName(String propertyName) throws UnmarshallException {
        ManagedProperty property = this._moType.getManagedProperty(propertyName);
        if (property == null) {
            throw new UnmarshallException(String.format("Request contains invalid managed property '%1$s'", propertyName));
        }
        this._managedMethod = property.getAccessor();
        this._args = EMPTY_ARGS;
    }

    public DeserializedRequest getDeserializedRequest() throws UnmarshallException {
        if (this._managedMethod == null) {
            this._managedMethod = MethodStackContext.findManagedMethod(this._methodName, this._moType, this._soapBinding.getVersion());
            this._args = new Object[this._managedMethod.getParameters().length];
        }
        VmodlField[] params = this._managedMethod.getParameters();
        for (int i = 0; i < params.length; ++i) {
            if (this._args[i] != null || params[i].isOptional()) continue;
            throw new UnmarshallException(String.format("Request missing value for required parameter '%1$s' to method '%2$s'", params[i].getName(), this._methodName));
        }
        return new DeserializedRequestImpl(this._bodyHandler, this._moRef, this._managedMethod, this._args);
    }

    public BodyHandler getBodyHandler() {
        return this._bodyHandler;
    }

    private static enum Match {
        MATCH,
        SKIP,
        MISMATCH;

    }
}

