/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.impl.unmarshaller;

import com.vmware.vim.vmomi.core.exception.UnmarshallException;
import com.vmware.vim.vmomi.core.soap.Constants;
import com.vmware.vim.vmomi.server.DeserializedRequest;
import com.vmware.vim.vmomi.server.Dispatcher;
import com.vmware.vim.vmomi.server.impl.unmarshaller.EnvelopeStackContext;
import com.vmware.vim.vmomi.server.impl.unmarshaller.StackContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class RequestUnmarshaller {
    private final Dispatcher _dispatcher;
    private final Stack<StackContext> _stack = new Stack();
    private final XMLStreamReader _input;
    private final String _soapAction;

    public RequestUnmarshaller(Dispatcher dispatcher, String soapAction, XMLStreamReader input) {
        this._dispatcher = dispatcher;
        this._soapAction = soapAction;
        this._input = input;
    }

    public DeserializedRequest unmarshalRequest() throws XMLStreamException, UnmarshallException {
        EnvelopeStackContext context = this.parseRequest();
        return context.getDeserializedRequest();
    }

    public EnvelopeStackContext parseRequest() throws XMLStreamException, UnmarshallException {
        StringBuilder buffer = null;
        this._input.nextTag();
        if (!this._input.getName().equals(Constants.ENV_QNAME)) {
            throw new UnmarshallException("Missing envelope");
        }
        EnvelopeStackContext context = new EnvelopeStackContext(this._dispatcher, this._soapAction, this._input);
        this._stack.push(context);
        while (!this._stack.empty() && this._input.hasNext()) {
            StackContext parent = this._stack.peek();
            int type = parent.nextParsingEvent(this._input);
            if (type != 4 && buffer != null) {
                parent.setValue(buffer.toString());
                buffer = null;
            }
            switch (type) {
                case 4: {
                    if (buffer == null) {
                        buffer = new StringBuilder();
                    }
                    buffer.append(this._input.getText());
                    break;
                }
                case 1: {
                    StackContext current = parent.getNestedContext(this._input.getName(), this.getAttributes());
                    if (current == null) break;
                    this._stack.push(current);
                    break;
                }
                case 2: 
                case 8: {
                    this._stack.pop();
                }
            }
        }
        if (!this._stack.empty()) {
            throw new UnmarshallException("Stack not empty after deserializing request");
        }
        return context;
    }

    private Map<QName, String> getAttributes() {
        if (0 == this._input.getAttributeCount()) {
            return Collections.emptyMap();
        }
        HashMap<QName, String> ret = new HashMap<QName, String>(this._input.getAttributeCount());
        for (int i = 0; this._input.getAttributeCount() > i; ++i) {
            QName qname = new QName(this._input.getAttributeNamespace(i), this._input.getAttributeLocalName(i), this._input.getAttributePrefix(i));
            ret.put(qname, this._input.getAttributeValue(i));
        }
        return ret;
    }
}

