/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.jms.impl;

import com.vmware.vim.vmomi.server.common.BindingInfo;
import com.vmware.vim.vmomi.server.common.ProcessingStep;
import com.vmware.vim.vmomi.server.common.Request;
import com.vmware.vim.vmomi.server.common.impl.RequestImpl;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RequestListener
implements MessageListener {
    private Log _logger = LogFactory.getLog(this.getClass());
    private ProcessingStep<Request> _nextStep;

    public RequestListener(ProcessingStep<Request> nextStep) {
        this._logger.info((Object)"Created request listener");
        this._nextStep = nextStep;
    }

    public void onMessage(Message message) {
        if (message instanceof MapMessage) {
            try {
                MapMessage map = (MapMessage)message;
                RequestImpl request = new RequestImpl(map.getString("VMWARE_correlator"));
                request.setRequestUri(map.getString("SOAPJMS_requestURI"));
                request.setSoapAction(map.getString("SOAPJMS_soapAction"));
                request.setContentType(map.getString("SOAPJMS_contentType"));
                request.setRequestBody(map.getString("body"));
                request.setSessionCookie(map.getString("VMWARE_sessionCookie"));
                request.setSessionCookiePath(map.getString("VMWARE_sessionCookiePath"));
                request.setBindingInfo(new JmsBindingInfo());
                this._nextStep.process(request);
            }
            catch (JMSException e) {
                this._logger.error((Object)"Unable to convert incoming JMS request message", (Throwable)e);
            }
        } else {
            this._logger.error((Object)"Received incoming JMS request of invalid type");
        }
    }

    public static class JmsBindingInfo
    implements BindingInfo {
    }
}

