/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.jms.impl;

import com.vmware.vim.vmomi.server.common.Response;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;

public class ResponseSender {
    private Log _logger = LogFactory.getLog(this.getClass());
    private JmsTemplate _jmsTemplate;

    public void setJmsTemplate(JmsTemplate jmsTemplate) {
        this._jmsTemplate = jmsTemplate;
    }

    public void send(Response response) {
        if (this._logger.isInfoEnabled()) {
            this._logger.info((Object)("Sending response: " + response.getCorrelator()));
        }
        this._jmsTemplate.send((MessageCreator)new ResponseMessageCreator(response));
    }

    static class ResponseMessageCreator
    implements MessageCreator {
        private Response _response;

        public ResponseMessageCreator(Response response) {
            this._response = response;
        }

        public Message createMessage(Session session) throws JMSException {
            MapMessage message = session.createMapMessage();
            message.setString("VMWARE_correlator", this._response.getCorrelator());
            message.setBoolean("SOAPJMS_isFault", this._response.isFault());
            message.setString("body", ((Object)this._response.getResponseBody()).toString());
            String sessionCookie = this._response.getSessionCookie();
            if (sessionCookie != null) {
                message.setString("VMWARE_sessionCookie", sessionCookie);
                String sessionCookiePath = this._response.getSessionCookiePath();
                if (sessionCookiePath != null) {
                    message.setString("VMWARE_sessionCookiePath", sessionCookiePath);
                }
            }
            return message;
        }
    }
}

