/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.jms.proxy.impl;

import com.vmware.vim.vmomi.server.common.Request;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;

public class RequestSender {
    private Log _logger = LogFactory.getLog(this.getClass());
    private JmsTemplate _jmsTemplate;
    private MessageCreator _creator;

    public void setJmsTemplate(JmsTemplate jmsTemplate) {
        this._jmsTemplate = jmsTemplate;
    }

    public void send(Request request) {
        if (this._logger.isInfoEnabled()) {
            this._logger.info((Object)("Sending request: " + request.getCorrelator()));
        }
        this._jmsTemplate.send((MessageCreator)new RequestMessageCreator(request));
    }

    static class RequestMessageCreator
    implements MessageCreator {
        private Request _request;

        public RequestMessageCreator(Request request) {
            this._request = request;
        }

        public Message createMessage(Session session) throws JMSException {
            MapMessage message = session.createMapMessage();
            message.setString("VMWARE_correlator", this._request.getCorrelator());
            message.setString("SOAPJMS_requestURI", this._request.getRequestUri());
            message.setString("SOAPJMS_soapAction", this._request.getSoapAction());
            message.setString("SOAPJMS_contentType", this._request.getContentType());
            message.setString("body", ((Object)this._request.getRequestBody()).toString());
            String cookie = this._request.getSessionCookie();
            if (cookie != null) {
                message.setString("VMWARE_sessionCookie", cookie);
                String cookiePath = this._request.getSessionCookiePath();
                if (cookiePath != null) {
                    message.setString("VMWARE_sessionCookiePath", cookiePath);
                }
            }
            return message;
        }
    }
}

