/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.mob.impl;

import com.vmware.vim.binding.impl.vmodl.DynamicPropertyImpl;
import com.vmware.vim.binding.vmodl.DynamicProperty;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.impl.BlockingFuture;
import com.vmware.vim.vmomi.core.soap.impl.CalendarHelper;
import com.vmware.vim.vmomi.core.types.ComplexType;
import com.vmware.vim.vmomi.core.types.ComplexTypeField;
import com.vmware.vim.vmomi.core.types.ManagedMethod;
import com.vmware.vim.vmomi.core.types.ManagedObjectType;
import com.vmware.vim.vmomi.core.types.ManagedProperty;
import com.vmware.vim.vmomi.core.types.Util;
import com.vmware.vim.vmomi.core.types.VmodlArrayType;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlField;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import com.vmware.vim.vmomi.core.util.EscapeCharactersUtil;
import com.vmware.vim.vmomi.server.LocalClient;
import com.vmware.vim.vmomi.server.mob.impl.RequestSettings;
import com.vmware.vim.vmomi.server.mob.impl.SampleValueGenerator;
import com.vmware.vim.vmomi.server.session.Session;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.util.Calendar;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MobRenderer {
    private final Log _logger = LogFactory.getLog(this.getClass());
    private final LocalClient _localClient;
    private final VmodlVersion _version;
    private final Session _session;
    private final String _urlPath;
    private final RequestSettings _settings;
    private final SampleValueGenerator _generator;
    private final VmodlContext _context;

    public MobRenderer(LocalClient localClient, VmodlVersion version, Session session, SampleValueGenerator generator, String urlPath, RequestSettings settings, VmodlContext context) {
        this._localClient = localClient;
        this._version = version;
        this._session = session;
        this._urlPath = urlPath;
        this._settings = settings;
        this._generator = generator;
        this._context = context;
    }

    public void renderEmbeddedComplexObject(ManagedObjectReference owner, Object obj, ComplexType type, CharSequence basePath, PrintWriter writer) {
        writer.write("<table summary=\"Table of properties for this Data Object\"><tr><th>Name</th><th>Type</th><th>Value</th></tr>");
        this.renderComplexObjectInt(owner, obj, type, basePath, false, writer);
        writer.write("</table>");
    }

    public void renderComplexObject(ManagedObjectReference owner, Object obj, ComplexType type, CharSequence basePath, PrintWriter writer) {
        this.renderComplexObjectInt(owner, obj, type, basePath, true, writer);
    }

    public void renderMethod(ManagedObject mObject, ManagedObjectType moType, ManagedMethod method, Map<String, String[]> args, Object result, String nonce, PrintWriter writer) {
        VmodlField[] parameters;
        VmodlType resultType = method.getResult().getType();
        writer.format("<table><tbody><tr class=\"title\"><td colspan=\"3\"><span class=\"object\">Managed Object Type: <strong>%1$s</strong></span><br /><span class=\"property\">Managed Object ID: <strong>%2$s</strong></span><br /><span class=\"property\">Method: <strong>%3$s</strong></span></td></tr></tbody></table><br /><h1>%4$s %3$s</h1>", this._settings.resolveDisplayName((VmodlType)moType), mObject._getRef().getValue(), this._settings.resolveDisplayName(method), this._settings.resolveDisplayName(resultType));
        StringBuilder paramString = new StringBuilder();
        for (VmodlField param : parameters = method.getParameters()) {
            if (!param.isVisible(this._version)) continue;
            String formatString = null;
            switch (param.getType().getKind()) {
                case ANY: 
                case DATA_OBJECT: 
                case FAULT: 
                case MOREF: 
                case MANAGED_OBJECT: 
                case ARRAY: {
                    formatString = "<textarea cols=\"10\" rows=\"5\" name=\"%s\">%s</textarea>";
                    break;
                }
                default: {
                    formatString = "<input name=\"%s\" type=\"text\" value=\"%s\"/>";
                }
            }
            String paramName = this._settings.resolveDisplayName(param);
            String argValue = "";
            argValue = args != null && args.containsKey(paramName) ? args.get(paramName)[0] : this._generator.generateSampleValue(param);
            String inputField = String.format(formatString, paramName, EscapeCharactersUtil.escapeXml((String)argValue));
            paramString.append(String.format("<tr><td class=\"c1\" nowrap=\"nowrap\"><strong>%s</strong> (%s)</td><td class=\"c2\" nowrap=\"nowrap\">%s</td><td>%s</td></tr>", paramName, param.isOptional() ? "optional" : "required", this._settings.resolveDisplayName(param.getType()), inputField));
        }
        String action = null;
        try {
            action = this._settings.resolveMethodAction(this._urlPath, mObject, method);
        }
        catch (UnsupportedEncodingException e) {
            if (this._logger.isWarnEnabled()) {
                this._logger.warn((Object)"Bad encoding", (Throwable)e);
            }
            return;
        }
        writer.format("<form name=\"method\" action=\"%s\" method=\"post\"><input name=\"%s\" type=\"hidden\" value=\"%s\"><p class=\"table-title\">Parameters</p><table cellspacing=\"0\"><tr><th>Name</th><th>Type</th><th>Value</th></tr>%s</table></form><br /><table><tr><td class=\"c1\" align=\"right\"><a href=\"javascript:invokeMethod()\">Invoke Method</a></td></tr></table>", action, "vmware-session-nonce", nonce, paramString);
        if (result != null) {
            writer.print("<br />");
            this.renderMethodResult(mObject, result, writer);
        }
    }

    private void renderMethodResult(ManagedObject mObject, Object result, PrintWriter writer) {
        Object cObj;
        ComplexType cType;
        if (result == null) {
            return;
        }
        VmodlType type = this._context.getVmodlTypeMap().getDynamicVmodlType(result);
        if (type instanceof ComplexType && type.getTypeClass().equals(result.getClass())) {
            cType = (ComplexType)type;
            cObj = result;
        } else {
            DynamicPropertyImpl d = new DynamicPropertyImpl();
            d.setName("Return value");
            if (type instanceof ComplexType) {
                d.setVal((Object)result.toString());
            } else {
                d.setVal(result);
            }
            cObj = d;
            cType = (ComplexType)this._context.getVmodlTypeMap().getVmodlType(DynamicProperty.class);
        }
        writer.format("<p class=\"table-title\">Method Invocation Result: %s</p>", this._settings.resolveDisplayName(type));
        this.renderEmbeddedComplexObject(mObject._getRef(), cObj, cType, "", writer);
    }

    private void renderComplexObjectInt(ManagedObjectReference owner, Object obj, ComplexType type, CharSequence basePath, boolean withCoLinks, PrintWriter writer) {
        ComplexTypeField[] props;
        ComplexType dynamicType = (ComplexType)Util.getVmodlObjectType((Object)obj, (VmodlContext)this._context);
        for (ComplexTypeField p : props = this._settings.resolveFieldsList(dynamicType, this._version)) {
            Object value = p.get(obj);
            this.renderField(p.getName(), p.getType(), value, owner, basePath, "<tr><td class=\"c2\">%s</td><td class=\"c1\">%s</td><td>", "</td></tr>", withCoLinks, writer);
        }
    }

    public void renderManagedObject(ManagedObject mObject, ManagedObjectType moType, PrintWriter writer) {
        ManagedMethod[] methods;
        ManagedProperty[] props;
        for (ManagedProperty p : props = this._settings.resolvePropertyList(moType, this._version)) {
            Object val;
            ManagedMethod getter = p.getAccessor();
            try {
                BlockingFuture f = new BlockingFuture();
                this._localClient.invoke(mObject, getter, new Object[0], this._version, this._session, (Future)f);
                val = f.get();
            }
            catch (Exception e) {
                if (!this._logger.isWarnEnabled()) continue;
                this._logger.warn((Object)"Caught unexpected exception while getting property.", (Throwable)e);
                continue;
            }
            this.renderField(p.getName(), p.getType(), val, mObject._getRef(), "", "<tr><td class=\"c2\">%s</td><td class=\"c1\">%s</td><td>", "</td></tr>", true, writer);
        }
        writer.print("</table>");
        writer.print("<br />");
        writer.print("<p class=\"table-title\">Methods</p><table><tr><th>Return Type</th><th>Name</th></tr>");
        for (ManagedMethod method : methods = this._settings.resolveMethodList(moType, this._version)) {
            VmodlType resultType = method.getResult().getType();
            writer.format("<tr><td class=\"c1\" nowrap=\"nowrap\">%s</td><td nowrap=\"nowrap\">%s</td></tr>", this._settings.resolveDisplayName(resultType), this._settings.resolveMethodLink(this._urlPath, mObject, method));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void renderField(String name, VmodlType type, Object obj, ManagedObjectReference owner, CharSequence basePath, String fieldStartTemplate, String fieldEnd, boolean withCoLinks, PrintWriter writer) {
        writer.format(fieldStartTemplate, name, this._settings.resolveDisplayName(type));
        if (obj != null) {
            if (type.getKind() == VmodlType.Kind.ANY) {
                type = this._context.getVmodlTypeMap().getDynamicVmodlType(obj);
            }
            switch (type.getKind()) {
                case BOOL: 
                case INT: 
                case ENUM: 
                case STRING: 
                case PROPERTY_PATH: 
                case BYTE: 
                case DOUBLE: 
                case FLOAT: 
                case SHORT: 
                case LONG: 
                case URI: 
                case BINARY: 
                case TYPE_NAME: 
                case METHOD_NAME: {
                    writer.print(obj);
                    break;
                }
                case DATETIME: {
                    writer.print(CalendarHelper.formatXsdDateTime((Calendar)((Calendar)obj)));
                    break;
                }
                case ANY: {
                    writer.print("XXX UNEXPECTED value is not a VMODL type");
                    break;
                }
                case MOREF: 
                case MANAGED_OBJECT: {
                    ManagedObjectReference moRef = obj instanceof ManagedObject ? ((ManagedObject)obj)._getRef() : (ManagedObjectReference)obj;
                    try {
                        writer.print(this._settings.resolveMorefLink(this._urlPath, moRef));
                    }
                    catch (UnsupportedEncodingException e) {
                        if (!this._logger.isWarnEnabled()) break;
                        this._logger.warn((Object)"Bad encoding", (Throwable)e);
                    }
                    break;
                }
                case ARRAY: {
                    this.renderArrayField(name, ((VmodlArrayType)type).getComponentType(), obj, owner, basePath, withCoLinks, writer);
                    break;
                }
                case DATA_OBJECT: 
                case FAULT: {
                    StringBuilder path = new StringBuilder(basePath);
                    if (path.length() != 0) {
                        path.append(".");
                    }
                    path.append(name);
                    if (withCoLinks) {
                        try {
                            writer.write(this._settings.resolveDataObjectLink(this._urlPath, owner, path.toString(), name));
                        }
                        catch (UnsupportedEncodingException e) {
                            if (!this._logger.isWarnEnabled()) break;
                            this._logger.warn((Object)"Bad encoding", (Throwable)e);
                        }
                        break;
                    }
                    this.renderEmbeddedComplexObject(owner, obj, (ComplexType)type, path, writer);
                    break;
                }
                default: {
                    writer.print("XXX UNEXPECTED default case reached");
                    break;
                }
            }
        } else {
            writer.print("Unset");
        }
        writer.print(fieldEnd);
    }

    private void renderArrayField(String name, VmodlType itemType, Object obj, ManagedObjectReference owner, CharSequence basePath, boolean withCoLinks, PrintWriter writer) {
        int length = Array.getLength(obj);
        if (length == 0) {
            return;
        }
        switch (itemType.getKind()) {
            case BOOL: 
            case INT: 
            case ENUM: 
            case STRING: 
            case PROPERTY_PATH: 
            case BYTE: 
            case DOUBLE: 
            case FLOAT: 
            case SHORT: 
            case LONG: 
            case URI: 
            case BINARY: 
            case TYPE_NAME: 
            case METHOD_NAME: 
            case DATETIME: {
                this.renderPrimitiveArray(obj, itemType, length, writer);
                break;
            }
            case MOREF: 
            case MANAGED_OBJECT: {
                this.renderManagedObjectArray(itemType, obj, length, owner, basePath, withCoLinks, writer);
                break;
            }
            case ARRAY: {
                writer.print("XXX UNEXPECTED array of arrays");
                break;
            }
            case ANY: {
                this.renderAnyArray(itemType, obj, length, owner, basePath, withCoLinks, writer);
                break;
            }
            case DATA_OBJECT: 
            case FAULT: {
                this.renderComplexArray(name, (ComplexType)itemType, obj, length, owner, basePath, withCoLinks, writer);
                break;
            }
            default: {
                writer.print("XXX UNEXPECTED default case reached for arrays");
            }
        }
    }

    private void renderAnyArray(VmodlType itemType, Object array, int length, ManagedObjectReference owner, CharSequence basePath, boolean withCoLinks, PrintWriter writer) {
        writer.print("<ul class=\"noindent\">");
        for (int i = 0; i < length; ++i) {
            Object item = Array.get(array, i);
            VmodlType dynamicType = this._context.getVmodlTypeMap().getDynamicVmodlType(item);
            this.renderField(null, dynamicType, item, owner, basePath, "<li>", "</li>", withCoLinks, writer);
        }
        writer.print("</ul>");
    }

    private void renderManagedObjectArray(VmodlType itemType, Object array, int length, ManagedObjectReference owner, CharSequence basePath, boolean withCoLinks, PrintWriter writer) {
        writer.print("<ul class=\"noindent\">");
        for (int i = 0; i < length; ++i) {
            Object item = Array.get(array, i);
            this.renderField(null, itemType, item, owner, basePath, "<li>", "</li>", withCoLinks, writer);
        }
        writer.print("</ul>");
    }

    private void renderComplexArray(String name, ComplexType itemType, Object array, int length, ManagedObjectReference owner, CharSequence basePath, boolean withCoLinks, PrintWriter writer) {
        ComplexTypeField keyProp = itemType.getProperty("key");
        if (keyProp == null && withCoLinks) {
            StringBuilder path = new StringBuilder(basePath);
            if (path.length() != 0) {
                path.append(".");
            }
            path.append(name);
            try {
                writer.write(this._settings.resolveDataObjectLink(this._urlPath, owner, path.toString(), name));
            }
            catch (UnsupportedEncodingException e) {
                if (this._logger.isWarnEnabled()) {
                    this._logger.warn((Object)"Bad encoding", (Throwable)e);
                }
                writer.format("XXX UNEXPECTED Bad encoding", new Object[0]);
            }
            return;
        }
        writer.print("<ul class=\"noindent\">");
        for (int i = 0; i < length; ++i) {
            Object item = Array.get(array, i);
            String keyName = null;
            if (keyProp != null) {
                Object keyVal = keyProp.get(item);
                if (keyProp.getType().getKind() == VmodlType.Kind.INT) {
                    keyName = String.format("%s[%d]", name, keyVal);
                } else if (keyProp.getType().getKind() == VmodlType.Kind.MOREF) {
                    keyName = String.format("%s[\"%s\"]", name, ((ManagedObjectReference)keyVal).getValue());
                } else if (keyProp.getType().getKind() == VmodlType.Kind.STRING) {
                    keyName = String.format("%s[\"%s\"]", name, keyVal);
                }
            }
            this.renderField(keyName, (VmodlType)itemType, item, owner, basePath, "<li>", "</li>", withCoLinks, writer);
        }
        writer.print("</ul>");
    }

    private void renderPrimitiveArray(Object obj, VmodlType itemType, int length, PrintWriter writer) {
        writer.print("<ul class=\"noindent\">");
        for (int i = 0; i < length; ++i) {
            Object item = Array.get(obj, i);
            this.renderField(null, itemType, item, null, "", "<li>", "</li>", false, writer);
        }
        writer.print("</ul>");
    }
}

