/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.mob.impl;

import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.types.ComplexType;
import com.vmware.vim.vmomi.core.types.ComplexTypeField;
import com.vmware.vim.vmomi.core.types.ManagedMethod;
import com.vmware.vim.vmomi.core.types.ManagedObjectType;
import com.vmware.vim.vmomi.core.types.ManagedProperty;
import com.vmware.vim.vmomi.core.types.VmodlField;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;

public class RequestSettings {
    private static final ListResolver<ManagedMethod> METHOD_LIST_RESOLVER = new ListResolver<ManagedMethod>(ManagedMethod.class){

        @Override
        protected boolean addInVmodlMode(ManagedMethod method, VmodlVersion version) {
            return !this.isPropertyAccessor(method);
        }

        @Override
        protected boolean addInWsdlMode(ManagedMethod method, VmodlVersion version) {
            if (this.isPropertyAccessor(method)) {
                return false;
            }
            return method.isVisible(version) && !method.isInternal();
        }

        @Override
        protected String getName(ManagedMethod method) {
            return method.getName();
        }

        private boolean isPropertyAccessor(ManagedMethod method) {
            return method.getManagedProperty() != null;
        }
    };
    private static final ListResolver<ManagedProperty> PROP_LIST_RESOLVER = new ListResolver<ManagedProperty>(ManagedProperty.class){

        @Override
        protected boolean addInVmodlMode(ManagedProperty prop, VmodlVersion version) {
            return true;
        }

        @Override
        protected boolean addInWsdlMode(ManagedProperty prop, VmodlVersion version) {
            return prop.isVisible(version);
        }

        @Override
        protected String getName(ManagedProperty prop) {
            return prop.getName();
        }
    };
    private static final ListResolver<ComplexTypeField> FIELD_LIST_RESOLVER = new ListResolver<ComplexTypeField>(ComplexTypeField.class){

        @Override
        protected boolean addInVmodlMode(ComplexTypeField field, VmodlVersion version) {
            return true;
        }

        @Override
        protected boolean addInWsdlMode(ComplexTypeField field, VmodlVersion version) {
            return field.isVisible(version);
        }

        @Override
        protected String getName(ComplexTypeField field) {
            return field.getName();
        }
    };
    private static final String MO_ID_NAME = "moid";
    private static final String CO_PATH_NAME = "doPath";
    private static final String METHOD_PATH_NAME = "method";
    private static final String VMODL_MODE = "vmodl";
    private final String _moId;
    private final String _coPath;
    private final String _method;
    private final boolean _displayVmodl;

    public RequestSettings(HttpServletRequest req) {
        this._moId = req.getParameter(MO_ID_NAME);
        this._coPath = req.getParameter(CO_PATH_NAME);
        this._method = req.getParameter(METHOD_PATH_NAME);
        this._displayVmodl = "1".equals(req.getParameter(VMODL_MODE));
    }

    public String getCoPath() {
        return this._coPath;
    }

    public boolean hasCoPath() {
        return this._coPath != null;
    }

    public String getMethod() {
        return this._method;
    }

    public boolean hasMethod() {
        return this._method != null;
    }

    public String getMoId() {
        return this._moId;
    }

    public boolean hasMoId() {
        return this._moId != null;
    }

    public ManagedMethod[] resolveMethodList(ManagedObjectType moType, VmodlVersion version) {
        return METHOD_LIST_RESOLVER.resolveList((ManagedMethod[])moType.getMethods(true), version, this._displayVmodl);
    }

    public ManagedProperty[] resolvePropertyList(ManagedObjectType moType, VmodlVersion version) {
        return PROP_LIST_RESOLVER.resolveList((ManagedProperty[])moType.getManagedProperties(), version, this._displayVmodl);
    }

    public ComplexTypeField[] resolveFieldsList(ComplexType coType, VmodlVersion version) {
        return FIELD_LIST_RESOLVER.resolveList((ComplexTypeField[])coType.getProperties(), version, this._displayVmodl);
    }

    public String resolveHomeUrl(String urlPath) {
        String template = this._displayVmodl ? "%s?vmodl=1" : "%s";
        return String.format(template, urlPath);
    }

    public String resolveMethodLink(String urlPath, ManagedObject mo, ManagedMethod method) {
        return String.format("<a href=\"javascript:openMethodInvocationWindow('%s','%s','%s', %b)\">%s</a>", urlPath, mo._getRef().getValue(), method.getWsdlName(), this._displayVmodl, this.resolveDisplayName(method));
    }

    public String resolveMethodAction(String urlPath, ManagedObject mo, ManagedMethod method) throws UnsupportedEncodingException {
        return this.resolveMethodAction(urlPath, mo._getRef().getValue(), method.getWsdlName());
    }

    public String resolveMethodAction(String urlPath, String moId, String methodName) throws UnsupportedEncodingException {
        String template = this._displayVmodl ? "%s?moid=%s&amp;method=%s&amp;vmodl=1" : "%s?moid=%s&amp;method=%s";
        return String.format(template, urlPath, URLEncoder.encode(moId, "UTF-8"), URLEncoder.encode(methodName, "UTF-8"));
    }

    public String resolveMorefLink(String urlPath, ManagedObjectReference moref) throws UnsupportedEncodingException {
        String template = this._displayVmodl ? "<a href=\"%s?moid=%s&amp;vmodl=1\">%s</a>" : "<a href=\"%s?moid=%s\">%s</a>";
        return String.format(template, urlPath, URLEncoder.encode(moref.getValue(), "UTF-8"), moref.getValue());
    }

    public String resolveDataObjectLink(String urlPath, ManagedObjectReference owner, String path, String name) throws UnsupportedEncodingException {
        String template = this._displayVmodl ? "<a href=\"%s?moid=%s&amp;doPath=%s&amp;vmodl=1\">%s</a>" : "<a href=\"%s?moid=%s&amp;doPath=%s\">%s</a>";
        return String.format(template, urlPath, URLEncoder.encode(owner.getValue(), "UTF-8"), URLEncoder.encode(path.toString(), "UTF-8"), name);
    }

    public String resolveDisplayName(VmodlType type) {
        String name = type == null ? "void" : (this._displayVmodl ? type.getTypeClass().getCanonicalName() : type.getWsdlName());
        return name;
    }

    public String resolveDisplayName(ManagedMethod method) {
        return this._displayVmodl ? method.getMethod().getName() : method.getWsdlName();
    }

    public String resolveDisplayName(VmodlField field) {
        return this._displayVmodl ? field.getName() : field.getWsdlName();
    }

    private static abstract class ListResolver<T> {
        private final Class<T> _typeToken;

        public ListResolver(Class<T> typeToken) {
            this._typeToken = typeToken;
        }

        public T[] resolveList(T[] initial, VmodlVersion version, boolean displayVmodl) {
            Collection<Object> result;
            if (displayVmodl) {
                ArrayList<T> list = new ArrayList<T>();
                for (T item : initial) {
                    if (!this.addInVmodlMode(item, version)) continue;
                    list.add(item);
                }
                result = list;
            } else {
                TreeMap<String, T> sorted = new TreeMap<String, T>();
                for (T item : initial) {
                    if (!this.addInWsdlMode(item, version)) continue;
                    sorted.put(this.getName(item), item);
                }
                result = sorted.values();
            }
            Object[] arrayResult = result.toArray((Object[])Array.newInstance(this._typeToken, result.size()));
            return arrayResult;
        }

        protected abstract String getName(T var1);

        protected abstract boolean addInVmodlMode(T var1, VmodlVersion var2);

        protected abstract boolean addInWsdlMode(T var1, VmodlVersion var2);
    }
}

