/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.n2r.impl;

import com.vmware.vim.vmomi.server.common.ProcessingStep;
import com.vmware.vim.vmomi.server.n2r.impl.Request;
import com.vmware.vim.vmomi.server.n2r.impl.Response;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class N2RServlet
extends HttpServlet {
    protected static final Log _logger = LogFactory.getLog(N2RServlet.class);
    protected ProcessingStep<Request> _firstStep;

    protected N2RServlet(ProcessingStep<Request> firstStep) {
        this._firstStep = firstStep;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.sendError(405);
    }

    protected boolean processNewRequest(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        if (_logger.isInfoEnabled()) {
            _logger.info((Object)String.format("Received new HTTP request: %s?%s", servletRequest.getPathInfo(), servletRequest.getQueryString()));
        }
        this._firstStep.process(new Request(servletRequest, servletResponse));
        return true;
    }

    protected void completeRequest(HttpServletRequest servletRequest, HttpServletResponse servletResponse, Object responseObject) throws IOException {
        Response response = (Response)responseObject;
        if (_logger.isInfoEnabled()) {
            _logger.info((Object)String.format("Finishing HTTP response with code %d", response.getResponseCode()));
        }
        if (response.getResponseCode() == 200) {
            servletResponse.setStatus(200);
        } else {
            servletResponse.sendError(response.getResponseCode());
        }
    }
}

