/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.security.impl;

import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.XmlParserFactory;
import com.vmware.vim.vmomi.core.util.CharSequenceReader;
import com.vmware.vim.vmomi.server.exception.InvalidSignatureException;
import com.vmware.vim.vmomi.server.exception.SignatureValidationException;
import com.vmware.vim.vmomi.server.security.RequestSignatureValidator;
import com.vmware.vim.vmomi.server.security.impl.WsSecurityMessage;
import java.io.IOException;
import java.io.Reader;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RequestSignatureValidatorImpl
implements RequestSignatureValidator {
    private static final long SECONDS_PER_MINUTE = 60L;
    private final ThreadLocal<DocumentBuilder> _documentBuilder = new ThreadLocal();
    private long _clockToleranceSeconds = 300L;

    private void initDocumentBuilder() throws SignatureValidationException {
        if (this._documentBuilder.get() == null) {
            try {
                this._documentBuilder.set(XmlParserFactory.Factory.createSecureXmlParserFactory().newDocumentBuilder());
            }
            catch (ParserConfigurationException e) {
                throw new SignatureValidationException("Failed to create secure DocumentBuilder", e);
            }
        }
    }

    @Override
    public final SamlToken validateMessage(CharSequence messageString, List<X509Certificate> stsCertificates) throws InvalidSignatureException, SignatureValidationException {
        this.initDocumentBuilder();
        Document message = this.parseMessageToDom(messageString);
        WsSecurityMessage secureMessage = WsSecurityMessage.findWsSecurityMessage(message, stsCertificates, this._clockToleranceSeconds);
        return secureMessage != null ? secureMessage.findAuthenticationInfo() : null;
    }

    public long getClockToleranceSeconds() {
        return this._clockToleranceSeconds;
    }

    public void setClockToleranceSeconds(long seconds) {
        if (seconds < 0L) {
            throw new IllegalArgumentException("clockToleranceSeconds must be a non-negative value");
        }
        this._clockToleranceSeconds = seconds;
    }

    private Document parseMessageToDom(CharSequence messageString) throws SignatureValidationException {
        try {
            this._documentBuilder.get().reset();
            return this._documentBuilder.get().parse(new InputSource((Reader)new CharSequenceReader(messageString)));
        }
        catch (SAXException e) {
            throw new SignatureValidationException("Error parsing SOAP message", e);
        }
        catch (IOException e) {
            throw new SignatureValidationException("Unexpected error reading from in-memory stream", e);
        }
    }
}

