/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.session.impl;

import com.vmware.vim.vmomi.core.util.SHA1HashGenerator;
import com.vmware.vim.vmomi.server.common.BindingInfo;
import com.vmware.vim.vmomi.server.session.Session;
import com.vmware.vim.vmomi.server.session.SessionAuthData;
import com.vmware.vim.vmomi.server.session.SessionObject;
import com.vmware.vim.vmomi.server.session.impl.SessionManagerImpl;
import java.util.HashMap;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SessionImpl
implements Session {
    private static Log LOG = LogFactory.getLog(SessionImpl.class);
    final Object lock = new Object();
    private final SessionManagerImpl _sessionManager;
    private final String _id;
    private SessionAuthData _authData;
    private final HashMap<String, SessionObject> _objectMap;
    private long _expirationDateMs;
    private String _sessionNonce;
    private int _useCount;
    private boolean _isClosed;
    private BindingInfo _bindingInfo;

    public SessionImpl(SessionManagerImpl sessionManager, String id) {
        this._sessionManager = sessionManager;
        this._id = id;
        this._authData = null;
        this._objectMap = new HashMap();
        this._bindingInfo = null;
        this._useCount = 1;
        this._isClosed = false;
        this._expirationDateMs = Long.MAX_VALUE;
        this._sessionNonce = UUID.randomUUID().toString();
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public Object getBindingInfo() {
        return this._bindingInfo;
    }

    @Override
    public void setBindingInfo(BindingInfo bindingInfo) {
        if (this._bindingInfo != null) {
            throw new IllegalStateException("BindingInfo can be set only once");
        }
        if (bindingInfo == null) {
            throw new IllegalArgumentException("BindingInfo is required");
        }
        this._bindingInfo = bindingInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SessionAuthData getAuthData() {
        Object object = this.lock;
        synchronized (object) {
            return this._authData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAuthData(SessionAuthData authData) {
        SessionManagerImpl sessionManagerImpl = this._sessionManager;
        synchronized (sessionManagerImpl) {
            Object object = this.lock;
            synchronized (object) {
                if (this._authData != null) {
                    throw new IllegalStateException("SessionAuthData can be set only once");
                }
                if (authData == null) {
                    throw new IllegalArgumentException("SessionAuthData is required");
                }
                this._authData = authData;
                this._sessionManager.sessionAuthDataSet(this._id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putSessionObject(String key, SessionObject object) {
        Object object2 = this.lock;
        synchronized (object2) {
            this._objectMap.put(key, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SessionObject getSessionObject(String key) {
        Object object = this.lock;
        synchronized (object) {
            return this._objectMap.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed() {
        Object object = this.lock;
        synchronized (object) {
            return this._isClosed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getExpirationDateMs() {
        Object object = this.lock;
        synchronized (object) {
            return this._expirationDateMs;
        }
    }

    @Override
    public String getSessionNonce() {
        return this._sessionNonce;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean changeExpirationDateMs(long newDateMs) {
        Object object = this.lock;
        synchronized (object) {
            if (newDateMs <= 0L) {
                throw new IllegalArgumentException("expiration date ms must be > 0");
            }
            if (this._isClosed) {
                return false;
            }
            if (this._useCount > 0) {
                throw new IllegalStateException("Session is in active use");
            }
            this._sessionManager.changeSessionExpirationDate(this, newDateMs);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeSession() {
        SessionManagerImpl sessionManagerImpl = this._sessionManager;
        synchronized (sessionManagerImpl) {
            Object object = this.lock;
            synchronized (object) {
                if (this._isClosed) {
                    return;
                }
                this._isClosed = true;
                if (this._useCount > 1 && LOG.isWarnEnabled()) {
                    LOG.warn((Object)("closeSession called for " + SHA1HashGenerator.generateTruncated((String)this._id) + " with use count " + this._useCount));
                }
                this._sessionManager.closeSession(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnSession() {
        SessionManagerImpl sessionManagerImpl = this._sessionManager;
        synchronized (sessionManagerImpl) {
            Object object = this.lock;
            synchronized (object) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Session " + SHA1HashGenerator.generateTruncated((String)this._id) + " returned, use count is " + this._useCount), (Throwable)new IllegalStateException("Used for stack trace only"));
                }
                if (this._isClosed) {
                    return;
                }
                if (this._useCount == 1) {
                    this._sessionManager.changeSessionExpirationDate(this, System.currentTimeMillis() + this._sessionManager.getSessionLifetime());
                }
                if (this._useCount <= 0) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)("Detected multiple session returns for session " + SHA1HashGenerator.generateTruncated((String)this._id)), (Throwable)new IllegalStateException("Used for stack trace only"));
                    }
                    return;
                }
                --this._useCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean useSession() {
        Object object = this.lock;
        synchronized (object) {
            if (this._isClosed) {
                return false;
            }
            if (this._useCount == 0) {
                this._sessionManager.changeSessionExpirationDate(this, Long.MAX_VALUE);
            }
            ++this._useCount;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getUseCount() {
        Object object = this.lock;
        synchronized (object) {
            return this._useCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setExpirationDateMs(long expirationDateMs) {
        Object object = this.lock;
        synchronized (object) {
            this._expirationDateMs = expirationDateMs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeSessionObjects() {
        Object object = this.lock;
        synchronized (object) {
            for (SessionObject o : this._objectMap.values()) {
                try {
                    o.sessionClosed();
                }
                catch (Throwable t) {
                    LOG.warn((Object)"Caught exception while closing session object", t);
                }
            }
            if (this._authData != null) {
                try {
                    this._authData.sessionClosed();
                }
                catch (Throwable t) {
                    LOG.warn((Object)"Caught exception while closing session auth data", t);
                }
            }
        }
    }
}

