/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.session.impl;

import com.vmware.vim.vmomi.core.common.LifecycleListener;
import com.vmware.vim.vmomi.core.util.SHA1HashGenerator;
import com.vmware.vim.vmomi.server.session.Session;
import com.vmware.vim.vmomi.server.session.SessionIdGenerator;
import com.vmware.vim.vmomi.server.session.SessionManager;
import com.vmware.vim.vmomi.server.session.impl.DefaultSessionIdGenerator;
import com.vmware.vim.vmomi.server.session.impl.Reaper;
import com.vmware.vim.vmomi.server.session.impl.SessionImpl;
import com.vmware.vim.vmomi.server.session.impl.SessionManagerImplMBean;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SessionManagerImpl
implements SessionManager,
LifecycleListener,
SessionManagerImplMBean {
    private static final Log LOG = LogFactory.getLog(SessionManagerImpl.class);
    private static final long ONE_MINUTE_MS = 60000L;
    private static final long DEFAULT_SESSION_LIFETIME_MS = 1800000L;
    private static final int DEFAULT_MAX_SESSIONS = 500;
    private long _sessionLifetimeMs;
    private int _maxSessions;
    private SessionIdGenerator _sessionIdGenerator;
    private final HashMap<String, SessionImpl> _authenticatedSessions = new HashMap();
    private final UnauthenticatedSessionMap _unauthenticatedSessions = new UnauthenticatedSessionMap();
    private final Reaper _reaper;

    public SessionManagerImpl() {
        this.setSessionLifetime(1800000L);
        this.setMaxSessions(500);
        this._reaper = new Reaper(this);
        this._sessionIdGenerator = new DefaultSessionIdGenerator();
    }

    @Override
    public void setSessionLimits(long sessionLifetimeMs, int maxSessions) {
        this.setSessionLifetime(sessionLifetimeMs);
        this.setMaxSessions(maxSessions);
    }

    @Override
    public synchronized int getMaxSessions() {
        return this._maxSessions;
    }

    @Override
    public synchronized void setMaxSessions(int maxSessions) {
        if (maxSessions <= 0) {
            throw new IllegalArgumentException("max sessions must be > 0");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Setting max session count to " + maxSessions));
        }
        this._maxSessions = maxSessions;
    }

    @Override
    public synchronized long getSessionLifetime() {
        return this._sessionLifetimeMs;
    }

    @Override
    public synchronized void setSessionLifetime(long sessionLifetimeMs) {
        if (sessionLifetimeMs <= 0L) {
            throw new IllegalArgumentException("session lifetime must be > 0");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Setting session lifetime to " + sessionLifetimeMs + " ms"));
        }
        this._sessionLifetimeMs = sessionLifetimeMs;
    }

    @Override
    public synchronized SessionIdGenerator getSessionIdGenerator() {
        return this._sessionIdGenerator;
    }

    @Override
    public synchronized void setSessionIdGenerator(SessionIdGenerator resolver) {
        if (resolver == null) {
            throw new IllegalArgumentException("SessionIdGenerator is required");
        }
        this._sessionIdGenerator = resolver;
    }

    @Override
    public Session createSession() {
        return this.createSession(null);
    }

    @Override
    public synchronized Session createSession(String clientSessionId) {
        if (this._authenticatedSessions.size() >= this._maxSessions) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)String.format("Too many authenticated sessions (%d), cannot create new session", this._authenticatedSessions.size()));
            }
            return null;
        }
        String serverSessionId = this._sessionIdGenerator.generateId(clientSessionId);
        if (serverSessionId == null || serverSessionId.isEmpty()) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)String.format("Generator returned an empty ID for client side session with ID %s", SHA1HashGenerator.generateTruncated((String)clientSessionId)));
            }
            return null;
        }
        SessionImpl session = this.getNewSession(serverSessionId);
        if (session == null) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)String.format("getNewSession() for ID %s returned null", SHA1HashGenerator.generateTruncated((String)serverSessionId)));
            }
            return null;
        }
        if (session.getId() != serverSessionId && LOG.isWarnEnabled()) {
            LOG.warn((Object)String.format("A new session should use ID %s but uses ID %s instead", SHA1HashGenerator.generateTruncated((String)session.getId()), SHA1HashGenerator.generateTruncated((String)serverSessionId)));
        }
        this._unauthenticatedSessions.put(session.getId(), session);
        return session;
    }

    protected SessionImpl getNewSession(String sessionId) {
        return new SessionImpl(this, sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session getSession(String id) {
        SessionImpl session;
        Object object = this;
        synchronized (object) {
            session = this._authenticatedSessions.get(id);
            if (session == null) {
                session = (SessionImpl)this._unauthenticatedSessions.get(id);
            }
        }
        if (session == null) {
            return null;
        }
        object = session.lock;
        synchronized (object) {
            if (session.useSession()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Getting session " + SHA1HashGenerator.generateTruncated((String)session.getId())));
                }
                return session;
            }
        }
        return null;
    }

    @Override
    public void returnSession(Session session) {
        if (session != null) {
            session.returnSession();
        }
    }

    synchronized void sessionAuthDataSet(String sessionId) {
        SessionImpl session = (SessionImpl)this._unauthenticatedSessions.remove(sessionId);
        if (session != null) {
            this._authenticatedSessions.put(sessionId, session);
        }
    }

    void changeSessionExpirationDate(Session session, long newExpirationDateMs) {
        this._reaper.requestExpirationChange((SessionImpl)session, newExpirationDateMs);
    }

    synchronized void closeSession(Session session) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("closeSession(" + SHA1HashGenerator.generateTruncated((String)session.getId()) + ')'));
        }
        if (session.getAuthData() != null) {
            if (this._authenticatedSessions.remove(session.getId()) != null && LOG.isDebugEnabled()) {
                LOG.debug((Object)("Removed authenticated session " + SHA1HashGenerator.generateTruncated((String)session.getId())));
            }
        } else if (this._unauthenticatedSessions.remove(session.getId()) != null && LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removed unauthenticated session " + SHA1HashGenerator.generateTruncated((String)session.getId())));
        }
        this._reaper.requestClosing((SessionImpl)session);
    }

    synchronized int getNumSessions() {
        return this._unauthenticatedSessions.size() + this._authenticatedSessions.size();
    }

    synchronized void dumpSessions() {
        if (LOG.isDebugEnabled()) {
            SessionImpl session;
            LOG.debug((Object)("Session dump as of " + System.currentTimeMillis()));
            LOG.debug((Object)"Unauthenticated sessions:");
            for (String key : this._unauthenticatedSessions.keySet()) {
                session = (SessionImpl)this._unauthenticatedSessions.get(key);
                LOG.debug((Object)(session.getUseCount() + " " + SHA1HashGenerator.generateTruncated((String)session.getId()) + " " + session.getExpirationDateMs()));
            }
            LOG.debug((Object)"Authenticated sessions:");
            for (String key : this._authenticatedSessions.keySet()) {
                session = this._authenticatedSessions.get(key);
                LOG.debug((Object)(session.getUseCount() + " " + SHA1HashGenerator.generateTruncated((String)session.getId()) + " " + session.getExpirationDateMs()));
            }
        }
    }

    public synchronized void shutdown() {
        this._reaper.stop(true);
    }

    public synchronized void shutdownNow() {
        this._reaper.stop(false);
    }

    @Override
    public int getAuthenticatedSessions() {
        return this._authenticatedSessions.size();
    }

    @Override
    public int getUnauthenticatedSessions() {
        return this._unauthenticatedSessions.size();
    }

    class UnauthenticatedSessionMap
    extends LinkedHashMap<String, SessionImpl> {
        UnauthenticatedSessionMap() {
            super(16, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, SessionImpl> eldest) {
            if (this.size() + SessionManagerImpl.this._authenticatedSessions.size() > SessionManagerImpl.this._maxSessions) {
                eldest.getValue().closeSession();
                return true;
            }
            return false;
        }
    }
}

