/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.impl;

import com.vmware.vim.vmomi.core.Future;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class BlockingFuture<T>
implements Future<T> {
    private Lock _lock = new ReentrantLock();
    private Condition _set = this._lock.newCondition();
    boolean _completed = false;
    private T _result;
    private Exception _fault;

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(T ret) {
        this._lock.lock();
        try {
            this._result = ret;
            this._completed = true;
            this._set.signalAll();
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public void set() {
        this.set((T)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setException(Exception fault) {
        this._lock.lock();
        try {
            this._fault = fault;
            this._completed = true;
            this._set.signalAll();
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() throws ExecutionException, InterruptedException {
        this._lock.lock();
        try {
            while (!this._completed) {
                this._set.await();
            }
            if (this._result != null) {
                T t = this._result;
                return t;
            }
            if (this._fault != null) {
                throw new ExecutionException(this._fault);
            }
            T t = null;
            return t;
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        this._lock.lock();
        try {
            while (!this._completed) {
                boolean signalled = this._set.await(timeout, unit);
                if (!signalled) {
                    throw new TimeoutException();
                }
                assert (this._completed);
            }
            if (this._result != null) {
                T t = this._result;
                return t;
            }
            if (this._fault != null) {
                throw new ExecutionException(this._fault);
            }
            T t = null;
            return t;
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        this._lock.lock();
        try {
            boolean bl = this._completed;
            return bl;
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public boolean isCancelled() {
        return false;
    }
}

