/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.impl;

import com.vmware.vim.binding.vmodl.DataObject;
import com.vmware.vim.vmomi.core.LinkResolver;
import com.vmware.vim.vmomi.core.exception.DuplicateLinkKeyException;
import com.vmware.vim.vmomi.core.exception.LinkNotFoundException;
import com.vmware.vim.vmomi.core.exception.UnexpectedTypeException;
import com.vmware.vim.vmomi.core.types.ComplexTypeField;
import com.vmware.vim.vmomi.core.types.DataObjectType;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlType;
import java.util.HashMap;
import java.util.Map;

public class LinkResolverImpl
implements LinkResolver {
    private final String KEY_PROP_NAME = "key";
    private Map<String, DataObject> _linkables;
    private final DataObject _scope;
    private final VmodlContext _context;

    public LinkResolverImpl(DataObject scope) throws DuplicateLinkKeyException {
        this(scope, VmodlContext.getContext());
    }

    public LinkResolverImpl(DataObject scope, VmodlContext context) throws DuplicateLinkKeyException {
        this._scope = scope;
        this._context = context;
        this.findLinkables();
    }

    @Override
    public DataObject resolve(String key) throws LinkNotFoundException {
        if (!this._linkables.containsKey(key)) {
            throw new LinkNotFoundException("Link not present in the provided scope");
        }
        return this._linkables.get(key);
    }

    @Override
    public DataObject[] resolve(String[] keys) throws LinkNotFoundException {
        DataObject[] ret = new DataObject[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            ret[i] = this.resolve(keys[i]);
        }
        return ret;
    }

    @Override
    public void verifyLinks() throws LinkNotFoundException {
        ComplexTypeField[] fields;
        DataObjectType doType = this.getDOType(this._scope);
        block4: for (ComplexTypeField field : fields = doType.getProperties()) {
            if (!field.isLink()) continue;
            Object propVal = field.get(this._scope);
            if (propVal == null) {
                if (field.isOptional()) continue;
                throw new NullPointerException("Missing non-optional property " + field.getName());
            }
            VmodlType linkType2 = field.getType();
            switch (linkType2.getKind()) {
                case STRING: {
                    this.checkLink((String)propVal, field);
                    continue block4;
                }
                case ARRAY: {
                    String[] keys;
                    for (String key : keys = (String[])propVal) {
                        if (key == null) {
                            throw new NullPointerException("null key in link property " + field.getName());
                        }
                        this.checkLink(key, field);
                    }
                    continue block4;
                }
                default: {
                    throw new UnexpectedTypeException(String.format("Unexpected type %1$s found for link. Expected types are String and Array", new Object[]{linkType2.getKind()}));
                }
            }
        }
    }

    private void checkLink(String key, ComplexTypeField field) throws LinkNotFoundException {
        if (!this._linkables.containsKey(key)) {
            throw new LinkNotFoundException(field.getName() + " link field not present in the provided scope");
        }
        if (!field.getLinkType().getTypeClass().isInstance(this._linkables.get(key))) {
            throw new UnexpectedTypeException("Expected " + field.getLinkType().getTypeClass() + " or compatible but found " + this._linkables.get(key).getClass());
        }
    }

    private void findLinkables() throws DuplicateLinkKeyException {
        this._linkables = new HashMap<String, DataObject>();
        DataObjectType doType = this.getDOType(this._scope);
        ComplexTypeField[] fields = doType.getProperties();
        block4: for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].isLinkable()) continue;
            VmodlType linkableType = fields[i].getType();
            switch (linkableType.getKind()) {
                case ARRAY: {
                    DataObject linkable2;
                    DataObject[] linkables = (DataObject[])fields[i].get(this._scope);
                    if (linkables != null) {
                        for (int j = 0; j < linkables.length; ++j) {
                            linkable2 = linkables[j];
                            if (linkable2 == null) continue;
                            this.processLinkable(linkables[j], this.getDOType(linkables[j]));
                        }
                        continue block4;
                    }
                    if (fields[i].isOptional()) continue block4;
                    throw new NullPointerException(fields[i].getName() + " field not optional");
                }
                case DATA_OBJECT: {
                    DataObject linkable2 = (DataObject)fields[i].get(this._scope);
                    if (linkable2 != null) {
                        this.processLinkable(linkable2, (DataObjectType)linkableType);
                        continue block4;
                    }
                    if (fields[i].isOptional()) continue block4;
                    throw new NullPointerException(fields[i].getName() + " field not optional");
                }
                default: {
                    throw new UnexpectedTypeException(String.format("Unexpected type %1$s found for link. Expected types are Array and Data", new Object[]{linkableType.getKind()}));
                }
            }
        }
    }

    private void processLinkable(DataObject linkable2, DataObjectType linkableType) throws DuplicateLinkKeyException {
        ComplexTypeField keyProp = linkableType.getProperty("key");
        String key = (String)keyProp.get(linkable2);
        if (key == null) {
            throw new NullPointerException("key null for linkable property");
        }
        if (this._linkables.containsKey(key)) {
            throw new DuplicateLinkKeyException(String.format("key %1$s key duplicated", key));
        }
        this._linkables.put(key, linkable2);
    }

    private DataObjectType getDOType(DataObject object) {
        return (DataObjectType)this._context.getVmodlTypeMap().getDynamicVmodlType(object);
    }
}

