/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.types.impl;

import com.vmware.vim.binding.vmodl.backwardCompatibility;
import com.vmware.vim.binding.vmodl.managedObjectType;
import com.vmware.vim.binding.vmodl.name;
import com.vmware.vim.binding.vmodl.optional;
import com.vmware.vim.binding.vmodl.privilege;
import com.vmware.vim.binding.vmodl.readonly;
import com.vmware.vim.binding.vmodl.versionClass;
import com.vmware.vim.binding.vmodl.wsdlName;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.types.ManagedMethod;
import com.vmware.vim.vmomi.core.types.ManagedObjectType;
import com.vmware.vim.vmomi.core.types.ManagedProperty;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlField;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.impl.ManagedMethodImpl;
import com.vmware.vim.vmomi.core.types.impl.ManagedPropertyImpl;
import com.vmware.vim.vmomi.core.types.impl.VmodlTypeImpl;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ManagedObjectTypeImpl
extends VmodlTypeImpl
implements ManagedObjectType {
    private ManagedObjectType _baseType;
    private Map<String, ManagedMethod> _methodsByName;
    private Map<String, ManagedMethod> _methodsByWsdlName;
    private Map<Method, ManagedMethod> _methodsByMethod;
    private Map<Method, int[]> _matchingParametersByMethod;
    private Map<String, ManagedProperty> _managedPropertiesByName;
    private Map<Method, ManagedProperty> _managedPropertiesByMethod;
    private ManagedMethod[] _methods;
    private ManagedMethod[] _methodsIncludingBases;

    public ManagedObjectTypeImpl(Class<?> clazz, VmodlContext context) {
        super(clazz, context);
    }

    void init() {
        ManagedMethod managedMethod;
        Class<?> clazz = this.getTypeClass();
        this._methodsByName = new HashMap<String, ManagedMethod>();
        this._methodsByWsdlName = new HashMap<String, ManagedMethod>();
        this._methodsByMethod = new HashMap<Method, ManagedMethod>();
        this._matchingParametersByMethod = new HashMap<Method, int[]>();
        this._managedPropertiesByName = new HashMap<String, ManagedProperty>();
        this._managedPropertiesByMethod = new HashMap<Method, ManagedProperty>();
        Class<?>[] superInterfaces = clazz.getInterfaces();
        if (superInterfaces != null && superInterfaces.length > 0) {
            VmodlType parentType = this.getVmodlContext().getVmodlTypeMap().getVmodlType(superInterfaces[0]);
            this._baseType = parentType != null && parentType.getKind() == VmodlType.Kind.MANAGED_OBJECT ? (ManagedObjectType)parentType : null;
        }
        ArrayList<ManagedMethodImpl> methods = new ArrayList<ManagedMethodImpl>();
        ArrayList<ManagedMethod> methodsIncludingBases = new ArrayList<ManagedMethod>();
        for (Method method : clazz.getMethods()) {
            name nameAnnotation;
            versionClass versionAnnotation = method.getAnnotation(versionClass.class);
            if (versionAnnotation == null) continue;
            managedMethod = new ManagedMethodImpl(this, method);
            methods.add((ManagedMethodImpl)managedMethod);
            if (method.getAnnotation(readonly.class) == null) continue;
            ManagedPropertyImpl property = new ManagedPropertyImpl(this, managedMethod, this.getVmodlContext());
            property.setVersion(this.getVmodlContext().getVmodlVersionMap().getVersion(versionAnnotation.value()));
            property.setOptional(method.getAnnotation(optional.class) != null);
            managedObjectType moTypeAnnotation = method.getAnnotation(managedObjectType.class);
            if (moTypeAnnotation != null) {
                property.setManagedObjectClassName(moTypeAnnotation.value());
            }
            if ((nameAnnotation = method.getAnnotation(name.class)) == null) {
                throw new IllegalStateException("Managed object type " + clazz.getName() + " managed property " + method.getName() + " is missing required @name annotation");
            }
            property.setName(nameAnnotation.value());
            privilege privilegeAnnotation = method.getAnnotation(privilege.class);
            if (privilegeAnnotation != null) {
                property.setPrivilegeId(privilegeAnnotation.value());
            }
            try {
                if (method.getGenericParameterTypes().length > 0) {
                    property.setType(ManagedMethodImpl.resolveFutureType(method.getGenericParameterTypes()[0], this.getVmodlContext()));
                } else {
                    Class<?> returnType = method.getReturnType();
                    VmodlType type = this.getVmodlContext().getVmodlTypeMap().getVmodlType(returnType);
                    if (type == null && returnType != Void.TYPE) {
                        throw new IllegalStateException("return type not found in vmodl type map");
                    }
                    property.setType(type);
                }
            }
            catch (Throwable t) {
                throw new IllegalStateException("Unable to resolve type of managed object " + clazz.getName() + " managed property " + property.getName());
            }
            this._managedPropertiesByName.put(property.getName(), property);
            this._managedPropertiesByMethod.put(method, property);
            ((ManagedMethodImpl)managedMethod).setManagedProperty(property);
        }
        this._methods = methods.toArray(new ManagedMethod[methods.size()]);
        if (this._baseType != null) {
            methodsIncludingBases.addAll(Arrays.asList(this._baseType.getMethods(true)));
        }
        methodsIncludingBases.addAll(methods);
        for (ManagedMethod method : methodsIncludingBases) {
            this._methodsByName.put(method.getName(), method);
            this._methodsByWsdlName.put(method.getWsdlName(), method);
            this._methodsByMethod.put(method.getMethod(), method);
        }
        this._methodsIncludingBases = methodsIncludingBases.toArray(new ManagedMethod[methodsIncludingBases.size()]);
        for (Method method : clazz.getMethods()) {
            name nameAnnotation = method.getAnnotation(name.class);
            wsdlName wsdlNameAnnotation = method.getAnnotation(wsdlName.class);
            if (method.getAnnotation(versionClass.class) != null) continue;
            if (nameAnnotation != null) {
                this._managedPropertiesByMethod.put(method, this.getManagedProperty(nameAnnotation.value()));
                continue;
            }
            if (wsdlNameAnnotation == null) continue;
            this._methodsByMethod.put(method, this._methodsByWsdlName.get(wsdlNameAnnotation.value()));
        }
        for (Method method : clazz.getMethods()) {
            backwardCompatibility backwardAnnotation = method.getAnnotation(backwardCompatibility.class);
            if (backwardAnnotation == null) continue;
            managedMethod = this._methodsByName.get(method.getName());
            String[] paramNames = backwardAnnotation.value();
            int[] matchingParams = new int[method.getParameterTypes().length];
            for (int i = 0; i < paramNames.length; ++i) {
                matchingParams[i] = this.getParameterPosition(paramNames[i], managedMethod.getParameters());
            }
            if (ManagedObjectTypeImpl.isAsyncMode(method.getParameterTypes())) {
                matchingParams[matchingParams.length - 1] = managedMethod.getParameters().length;
            }
            this._matchingParametersByMethod.put(method, matchingParams);
        }
        this.setKind(VmodlType.Kind.MANAGED_OBJECT);
    }

    private int getParameterPosition(String paramName, VmodlField[] parameters) {
        for (int j = 0; j < parameters.length; ++j) {
            if (!paramName.equals(parameters[j].getName())) continue;
            return j;
        }
        return -1;
    }

    @Override
    public ManagedMethod getMethod(String name2) {
        return this._methodsByName.get(name2);
    }

    @Override
    public ManagedMethod getMethod(Method method) {
        return this._methodsByMethod.get(method);
    }

    @Override
    public ManagedMethod getWsdlMethod(String wsdlName2) {
        return this._methodsByWsdlName.get(wsdlName2);
    }

    @Override
    public int[] getMatchingParameters(Method method) {
        return this._matchingParametersByMethod.get(method);
    }

    @Override
    public ManagedMethod[] getMethods(boolean includeBases) {
        return includeBases ? this._methods : this._methodsIncludingBases;
    }

    @Override
    public ManagedProperty[] getManagedProperties() {
        return this._managedPropertiesByName.values().toArray(new ManagedProperty[this._managedPropertiesByName.size()]);
    }

    @Override
    public ManagedProperty getManagedProperty(String name2) {
        return this._managedPropertiesByName.get(name2);
    }

    @Override
    public ManagedProperty getManagedProperty(Method method) {
        return this._managedPropertiesByMethod.get(method);
    }

    @Override
    public ManagedObjectType getBaseType() {
        return this._baseType;
    }

    private static boolean isAsyncMode(Class<?>[] clazz) {
        return clazz != null && clazz.length > 0 && clazz[clazz.length - 1].isAssignableFrom(Future.class);
    }
}

