/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.types.impl;

import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vim.binding.vmodl.wsdlName;
import com.vmware.vim.vmomi.core.soap.Marshaller;
import com.vmware.vim.vmomi.core.soap.Unmarshaller;
import com.vmware.vim.vmomi.core.soap.impl.marshaller.MarshallerImpl;
import com.vmware.vim.vmomi.core.soap.impl.unmarshaller.UnmarshallerImpl;
import com.vmware.vim.vmomi.core.types.DataObjectFactory;
import com.vmware.vim.vmomi.core.types.ManagedObjectFactory;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import com.vmware.vim.vmomi.core.types.VmodlVersionMap;
import com.vmware.vim.vmomi.core.types.impl.DefaultDataObjectFactory;
import com.vmware.vim.vmomi.core.types.impl.VmodlArrayTypeImpl;
import com.vmware.vim.vmomi.core.types.impl.VmodlContextLoader;
import com.vmware.vim.vmomi.core.types.impl.VmodlTypeMapImpl;
import com.vmware.vim.vmomi.core.util.ClassUtil;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class VmodlContextImpl
extends VmodlContext {
    private static final String CONTEXT_FILE = "/context.xml";
    private static final String CONTEXT_FILE_V2 = "/context_v2.xml";
    private static final String CONTEXT_BEAN_NAME = "context";
    private static final String CORE_VMODL_PACKAGE = "com.vmware.vim.binding.vmodl";
    private static final String QUERY_VMODL_PACKAGE = "com.vmware.vim.binding.vmodl.query";
    private static final String ARRAY_WSDL_NAME_PREFIX = "ArrayOf";
    private final VmodlTypeMap _typeMap;
    private final VmodlVersionMap _versionMap;
    private final Map<String, VmodlContextLoader> _loaderByClass;
    private final Map<String, VmodlContextLoader> _loaderByWsdlName;
    private final Map<String, WeakReference<ClassLoader>> _classLoaderByPackage;
    private final Map<Class<?>, Boolean> _resolveMoType = new ConcurrentHashMap();
    private DataObjectFactory _requestDataObjectFactory = new DefaultDataObjectFactory();
    private DataObjectFactory _responseDataObjectFactory = new DefaultDataObjectFactory();
    private static final Log _logger = LogFactory.getLog(VmodlContextImpl.class);
    private final Object _lock = new Object();
    private static final VmodlContext _coreContext = new VmodlContextImpl(false, false);

    public VmodlContextImpl() {
        this(true, false);
    }

    public VmodlContextImpl(boolean singleton, boolean lazyLoad) {
        if (singleton) {
            this._typeMap = VmodlTypeMap.Factory.getTypeMap();
            this._versionMap = VmodlVersionMap.Factory.getVmodlVersionMap();
        } else {
            this._typeMap = VmodlTypeMap.Factory.createTypeMap();
            this._versionMap = VmodlVersionMap.Factory.createVersionMap();
        }
        ((VmodlTypeMapImpl)this._typeMap).setVmodlContext(this);
        this._loaderByClass = new ConcurrentHashMap<String, VmodlContextLoader>();
        this._loaderByWsdlName = new ConcurrentHashMap<String, VmodlContextLoader>();
        this._classLoaderByPackage = new ConcurrentHashMap<String, WeakReference<ClassLoader>>();
        this.loadVmodlPackage(CORE_VMODL_PACKAGE, false);
        String queryVmodlContextPath = this.getContextFileNameForPackage(QUERY_VMODL_PACKAGE);
        if (ClassUtil.getCurrentClassLoader().getResource(queryVmodlContextPath) != null) {
            this.loadVmodlPackage(QUERY_VMODL_PACKAGE, lazyLoad);
        }
        VmodlType methodFaultType = this._typeMap.getVmodlType(MethodFault.class);
        VmodlType methodFaultArrType = this._typeMap.getVmodlType("ArrayOfMethodFault");
        ((VmodlArrayTypeImpl)methodFaultArrType).setItemType(Exception.class);
        this._typeMap.registerType(Exception.class, methodFaultType);
        this._typeMap.registerType(Array.newInstance(Exception.class, 0).getClass(), methodFaultArrType);
        this._typeMap.registerType("LocalizedMethodFault", methodFaultType);
    }

    @Override
    public void loadVmodlPackages(String[] vmodlPackages) {
        this.loadVmodlPackages(vmodlPackages, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadVmodlPackages(String[] vmodlPackages, boolean lazyInit) {
        Object object = this._lock;
        synchronized (object) {
            for (String pack : vmodlPackages) {
                this.loadVmodlPackage(pack, lazyInit);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadVmodlPackage(String vmodlPackage, boolean lazyInit) {
        long initLoadTime = System.nanoTime();
        String contextPath = this.getContextFileNameForPackage(vmodlPackage);
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)String.format("%s loading vmodl context %s from %s", lazyInit ? "Lazily" : "Eagerly", vmodlPackage, ClassUtil.getCurrentClassLoader().getResource(contextPath)));
        }
        NonValidatingClassPathXmlApplicationContext ctx = new NonValidatingClassPathXmlApplicationContext(contextPath);
        try {
            VmodlContextLoader loader = (VmodlContextLoader)ctx.getBean(CONTEXT_BEAN_NAME);
            this.doLoadVmodlPackage(loader, vmodlPackage, lazyInit);
            loader.registerPackageClassLoaders(this._classLoaderByPackage);
            if (lazyInit) {
                loader.registerLoaderByWsdlName(this._loaderByWsdlName);
                loader.registerLoaderByClass(this._loaderByClass);
            }
        }
        finally {
            ctx.close();
        }
        if (_logger.isInfoEnabled()) {
            _logger.info((Object)String.format("Package %s loaded in %d millis", vmodlPackage, (System.nanoTime() - initLoadTime) / 1000000L));
        }
    }

    private void doLoadVmodlPackage(VmodlContextLoader loader, String vmodlPackage, boolean lazyInit) {
        loader.load(this, lazyInit);
        boolean resolveMoType = loader.isHideMoRef();
        if (resolveMoType && _logger.isInfoEnabled()) {
            _logger.info((Object)String.format("Managed object reference hiding enabled by '%s'", vmodlPackage));
        }
        for (Class<?> version : loader.getVmodlVersionContext()) {
            this._resolveMoType.put(version, resolveMoType);
        }
    }

    public boolean isResolveMoType(Class<?> version) {
        Boolean res = this._resolveMoType.get(version);
        if (res == null) {
            throw new IllegalArgumentException("Unknown version " + version);
        }
        return res;
    }

    public boolean isResolveMoType(VmodlVersion version) {
        return this.isResolveMoType(version.getVersionClass());
    }

    @Override
    public Marshaller createMarshaller(VmodlVersion version) {
        return new MarshallerImpl(version, this, false);
    }

    @Override
    public Marshaller createQSMarshaller(VmodlVersion version) {
        return new MarshallerImpl(version, this, true);
    }

    @Override
    public Unmarshaller createRequestUnmarshaller(VmodlVersion version) {
        return new UnmarshallerImpl(this, version, this._requestDataObjectFactory, this.isResolveMoType(version), null, false);
    }

    @Override
    public Unmarshaller createResponseUnmarshaller(VmodlVersion version) {
        return this.createResponseUnmarshaller(version, null);
    }

    @Override
    public Unmarshaller createResponseUnmarshaller(VmodlVersion version, ManagedObjectFactory managedObjectFactory) {
        if (managedObjectFactory == null && this.isResolveMoType(version)) {
            throw new IllegalArgumentException("ManagedObjectFactory is required to unmarshall response for bindings emitted with hide-mo-ref=true");
        }
        return new UnmarshallerImpl(this, version, this._responseDataObjectFactory, this.isResolveMoType(version), managedObjectFactory, false);
    }

    @Override
    public Unmarshaller createQSResponseUnmarshaller(VmodlVersion version, ManagedObjectFactory managedObjectFactory) {
        if (managedObjectFactory == null && this.isResolveMoType(version)) {
            throw new IllegalArgumentException("ManagedObjectFactory is required to unmarshall response for bindings emitted with hide-mo-ref=true");
        }
        return new UnmarshallerImpl(this, version, this._responseDataObjectFactory, this.isResolveMoType(version), managedObjectFactory, true);
    }

    @Override
    public void setRequestDataObjectFactory(DataObjectFactory factory) {
        this._requestDataObjectFactory = factory;
    }

    @Override
    public DataObjectFactory getRequestDataObjectFactory() {
        return this._requestDataObjectFactory;
    }

    @Override
    public void setResponseDataObjectFactory(DataObjectFactory factory) {
        this._responseDataObjectFactory = factory;
    }

    @Override
    public DataObjectFactory getResponseDataObjectFactory() {
        return this._responseDataObjectFactory;
    }

    private String getContextFileNameForPackage(String packageName) {
        String contextPath = this.getContextFileNameForPackage(packageName, CONTEXT_FILE_V2);
        if (ClassUtil.getCurrentClassLoader().getResource(contextPath) == null) {
            contextPath = this.getContextFileNameForPackage(packageName, CONTEXT_FILE);
        }
        return contextPath;
    }

    private String getContextFileNameForPackage(String packageName, String contextFile) {
        return packageName.replace('.', '/') + contextFile;
    }

    @Override
    public VmodlTypeMap getVmodlTypeMap() {
        return this._typeMap;
    }

    @Override
    public VmodlVersionMap getVmodlVersionMap() {
        return this._versionMap;
    }

    public static VmodlContext getCoreContext() {
        return _coreContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadVmodlType(Class<?> clazz) {
        if (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        Class<?> loadClass = clazz;
        while (loadClass.getEnclosingClass() != null) {
            loadClass = loadClass.getEnclosingClass();
        }
        Object object = this._lock;
        synchronized (object) {
            VmodlContextLoader loader = this._loaderByClass.get(loadClass.getName());
            if (loader != null) {
                this.unregisterLoader(loadClass);
                loader.loadType(loadClass);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadVmodlType(String wsdlType) {
        Object object = this._lock;
        synchronized (object) {
            VmodlContextLoader loader = this._loaderByWsdlName.get(wsdlType);
            if (loader == null && wsdlType.startsWith(ARRAY_WSDL_NAME_PREFIX)) {
                wsdlType = this.getComponentType(wsdlType);
                loader = this._loaderByWsdlName.get(wsdlType);
            }
            if (loader != null) {
                String className = loader.getWsdlNameContext(wsdlType);
                try {
                    if (this._loaderByClass.containsKey(className)) {
                        Class<?> clazz = this.loadClass(className);
                        this.unregisterLoader(clazz);
                        loader.loadType(clazz);
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Error resolving class " + className, e);
                }
            }
        }
    }

    Class<?> loadClass(String className) throws ClassNotFoundException {
        ClassLoader classLoader = this.getClassLoader(className);
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)String.format("Loading class %s with class loader %s", className, classLoader));
        }
        return classLoader.loadClass(className);
    }

    private ClassLoader getClassLoader(String className) {
        WeakReference<ClassLoader> classLoader;
        String packageName = ClassUtil.getPackageName(className);
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)String.format("Looking for class loader for package %s", packageName));
        }
        if ((classLoader = this._classLoaderByPackage.get(packageName)) != null && classLoader.get() != null) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)String.format("Class loader %s found for current package", classLoader.get()));
            }
            return (ClassLoader)classLoader.get();
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)"Class loader not found or unloaded for current package. Returning the current class loader.");
        }
        return ClassUtil.getCurrentClassLoader();
    }

    private String getComponentType(String wsdlType) {
        String componentType = wsdlType.substring(ARRAY_WSDL_NAME_PREFIX.length());
        if (!this._loaderByWsdlName.containsKey(componentType)) {
            char[] chars = componentType.toCharArray();
            chars[0] = Character.toLowerCase(chars[0]);
            componentType = new String(chars);
        }
        return componentType;
    }

    private void unregisterLoader(Class<?> clazz) {
        this._loaderByClass.remove(clazz.getName());
        wsdlName wsdlNameAnnotation = clazz.getAnnotation(wsdlName.class);
        if (wsdlNameAnnotation != null) {
            this._loaderByWsdlName.remove(wsdlNameAnnotation.value());
        }
        for (Class<?> innerClass : clazz.getClasses()) {
            wsdlNameAnnotation = innerClass.getAnnotation(wsdlName.class);
            if (wsdlNameAnnotation == null) continue;
            this._loaderByWsdlName.remove(wsdlNameAnnotation.value());
        }
    }

    private class NonValidatingClassPathXmlApplicationContext
    extends ClassPathXmlApplicationContext {
        NonValidatingClassPathXmlApplicationContext(String contextPath) {
            super(contextPath);
        }

        protected void initBeanDefinitionReader(XmlBeanDefinitionReader beanDefinitionReader) {
            super.initBeanDefinitionReader(beanDefinitionReader);
            beanDefinitionReader.setValidationMode(0);
        }
    }
}

