/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.types.impl;

import com.vmware.vim.vmomi.core.exception.VmodlAlreadyLoadedException;
import com.vmware.vim.vmomi.core.types.ManagedMethod;
import com.vmware.vim.vmomi.core.types.ManagedObjectType;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vim.vmomi.core.types.VmomiService;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class VmodlTypeMapImpl
implements VmodlTypeMap {
    private Map<String, VmodlType> _wsdlTypeMap = new ConcurrentHashMap<String, VmodlType>();
    private Map<String, VmodlType> _allWsdlTypeMap = new ConcurrentHashMap<String, VmodlType>();
    private Map<Class<?>, VmodlType> _classTypeMap = new ConcurrentHashMap();
    private Map<Class<?>, VmodlType> _allClassTypeMap = new ConcurrentHashMap();
    private Map<String, ManagedMethod> _wsdlOperationMap = new ConcurrentHashMap<String, ManagedMethod>();
    private Map<String, VmodlType> _wsdlNamespaceTypeMap = new ConcurrentHashMap<String, VmodlType>();
    private Map<String, ManagedMethod> _wsdlNamespaceOperationMap = new ConcurrentHashMap<String, ManagedMethod>();
    private VmodlContext _context;

    public void setVmodlContext(VmodlContext context) {
        this._context = context;
    }

    @Override
    public VmodlType getVmodlType(String wsdlType) {
        VmodlType type = this._allWsdlTypeMap.get(wsdlType);
        if (type == null && this._context != null) {
            this._context.loadVmodlType(wsdlType);
            type = this._allWsdlTypeMap.get(wsdlType);
        }
        return type;
    }

    @Override
    public VmodlType getLoadedVmodlType(String wsdlType) {
        VmodlType type = this._wsdlTypeMap.get(wsdlType);
        if (type == null && this._context != null) {
            this._context.loadVmodlType(wsdlType);
            type = this._wsdlTypeMap.get(wsdlType);
        }
        return type;
    }

    @Override
    public VmodlType getVmodlType(Class<?> clazz) {
        VmodlType type = this._allClassTypeMap.get(clazz);
        if (type == null && this._context != null) {
            this._context.loadVmodlType(clazz);
            type = this._allClassTypeMap.get(clazz);
        }
        return type;
    }

    @Override
    public VmodlType getLoadedVmodlType(Class<?> clazz) {
        VmodlType type = this._classTypeMap.get(clazz);
        if (type == null && this._context != null) {
            this._context.loadVmodlType(clazz);
            type = this._classTypeMap.get(clazz);
        }
        return type;
    }

    @Override
    public VmodlType getDynamicVmodlType(Object obj) {
        Class<?> componentClass;
        VmodlType componentType;
        Class<?> clazz = obj.getClass();
        VmodlType dynamicType = this.findDynamicType(clazz);
        if (dynamicType == null && clazz.isArray() && (componentType = this.findDynamicType(componentClass = clazz.getComponentType())) != null) {
            clazz = Array.newInstance(componentType.getTypeClass(), 0).getClass();
            dynamicType = this.getVmodlType(clazz);
        }
        return dynamicType;
    }

    private VmodlType findDynamicType(Class<?> clazz) {
        VmodlType dynamicType = null;
        for (Class<?> currentClass = clazz; currentClass != null && !currentClass.equals(Object.class) && dynamicType == null; currentClass = currentClass.getSuperclass()) {
            dynamicType = this.getVmodlType(currentClass);
            if (dynamicType != null) continue;
            dynamicType = this.getTypeByObjectInterface(currentClass);
        }
        return dynamicType;
    }

    private VmodlType getTypeByObjectInterface(Class<?> clazz) {
        Class<?>[] interfaces;
        for (Class<?> iface : interfaces = clazz.getInterfaces()) {
            if (!this._allClassTypeMap.containsKey(iface) && this._context != null) {
                this._context.loadVmodlType(iface);
            }
            if (this._allClassTypeMap.containsKey(iface)) {
                return this.getVmodlType(iface);
            }
            VmodlType ret = this.getTypeByObjectInterface(iface);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    @Override
    public ManagedMethod getManagedMethod(String wsdlOperationName) {
        return this._wsdlOperationMap.get(wsdlOperationName);
    }

    @Override
    public void registerType(String wsdlName2, VmodlType type) {
        String key;
        if (!this._allWsdlTypeMap.containsKey(wsdlName2)) {
            this._allWsdlTypeMap.put(wsdlName2, type);
            if (!(type instanceof ManagedObjectType)) {
                this._wsdlTypeMap.put(wsdlName2, type);
            }
        }
        if (!this._wsdlNamespaceTypeMap.containsKey(key = this.createWSDLKey(wsdlName2, type.getVersion().getService()))) {
            this._wsdlNamespaceTypeMap.put(key, type);
        }
    }

    @Override
    public void registerType(Class<?> clazz, VmodlType type) {
        if (this._allClassTypeMap.containsKey(clazz)) {
            throw new VmodlAlreadyLoadedException(String.format("Class %1$s already registered", clazz.getName()));
        }
        this._allClassTypeMap.put(clazz, type);
        if (!(type instanceof ManagedObjectType)) {
            this._classTypeMap.put(clazz, type);
        }
        this.registerType(type.getWsdlName(), type);
    }

    @Override
    public void registerOperations(ManagedObjectType type) {
        Class<?> clazz = type.getTypeClass();
        this._classTypeMap.put(clazz, type);
        this._wsdlTypeMap.put(type.getWsdlName(), type);
        ManagedMethod[] methods = type.getMethods(false);
        for (int i = 0; i < methods.length; ++i) {
            ManagedMethod method = methods[i];
            this._wsdlOperationMap.put(method.getWsdlName(), method);
            this._wsdlNamespaceOperationMap.put(this.createWSDLKey(method.getWsdlName(), type.getVersion().getService()), method);
        }
    }

    @Override
    public void registerType(VmodlType type) {
        this.registerType(type.getTypeClass(), type);
    }

    @Override
    public ManagedMethod getManagedMethod(String wsdlOperationName, VmomiService service2) {
        return this._wsdlNamespaceOperationMap.get(this.createWSDLKey(wsdlOperationName, service2));
    }

    @Override
    public VmodlType getVmodlType(String wsdlType, VmomiService service2) {
        String key = this.createWSDLKey(wsdlType, service2);
        VmodlType type = this._wsdlNamespaceTypeMap.get(key);
        if (type == null && this._context != null) {
            this._context.loadVmodlType(wsdlType);
            type = this._wsdlNamespaceTypeMap.get(key);
        }
        return type;
    }

    @Override
    public List<VmodlType> getVmodlTypes() {
        return new ArrayList<VmodlType>(this._allClassTypeMap.values());
    }

    private String createWSDLKey(String wsdlName2, VmomiService service2) {
        if (service2 != null) {
            return service2.getServiceNamespace() + ":" + wsdlName2;
        }
        return wsdlName2;
    }
}

