/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.util;

import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.serviceId;
import com.vmware.vim.binding.vmodl.serviceObject;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class ServiceObjectUtil {
    private static <T extends Annotation> T getAnnotationRecursive(Class<?> clazz, Class<T> annotationClass) {
        T annotation = clazz.getAnnotation(annotationClass);
        if (annotation != null) {
            return annotation;
        }
        for (Class<?> iface : clazz.getInterfaces()) {
            T ifaceAnnotation = ServiceObjectUtil.getAnnotationRecursive(iface, annotationClass);
            if (ifaceAnnotation == null) continue;
            return ifaceAnnotation;
        }
        if (clazz.getSuperclass() != null) {
            return ServiceObjectUtil.getAnnotationRecursive(clazz.getSuperclass(), annotationClass);
        }
        return null;
    }

    private static String getServiceId(Class<?> clazz) {
        serviceId serviceIdAnnotation = ServiceObjectUtil.getAnnotationRecursive(clazz, serviceId.class);
        if (serviceIdAnnotation == null) {
            throw new IllegalArgumentException("Class " + clazz.getCanonicalName() + " is missing @serviceId annotation.");
        }
        return serviceIdAnnotation.value();
    }

    public static ManagedObjectReference createServiceMoRef(Class<?> clazz) {
        String serviceId2 = ServiceObjectUtil.getServiceId(clazz);
        ManagedObjectReference moRef = new ManagedObjectReference(null, serviceId2, null);
        return moRef;
    }

    public static ManagedObject adaptService(ManagedObject mo) {
        serviceObject serviceObjectAnnotation = ServiceObjectUtil.getAnnotationRecursive(mo.getClass(), serviceObject.class);
        if (serviceObjectAnnotation == null) {
            return mo;
        }
        return (ManagedObject)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), mo.getClass().getInterfaces(), (InvocationHandler)new ServiceInvocationHandler(mo));
    }

    private static class ServiceInvocationHandler
    implements InvocationHandler {
        private final Object impl;

        public ServiceInvocationHandler(Object impl) {
            this.impl = impl;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("_getRef".equals(method.getName())) {
                return ServiceObjectUtil.createServiceMoRef(this.impl.getClass());
            }
            Method implMethod = this.impl.getClass().getMethod(method.getName(), method.getParameterTypes());
            return implMethod.invoke(this.impl, args);
        }
    }
}

