/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sso.admin.exception;

import com.vmware.vsphere.client.sso.admin.exception.BackendExceptionTransformer;
import com.vmware.vsphere.client.sso.admin.exception.SsoBackendException;
import com.vmware.vsphere.client.sso.admin.util.SsoAdminUtil;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TypedExceptionTransformer
extends BackendExceptionTransformer {
    private static final Log _logger = LogFactory.getLog(TypedExceptionTransformer.class);
    private static final String TRANSLATION_DOMAIN_PREFIX = "sso.admin.";
    private static final String CODE_DOMAIN = "com.vmware.vsphere.client";

    @Override
    public Exception transform(Exception exception) {
        Serializable serializable;
        String string = null;
        if (exception.getStackTrace().length > 0) {
            serializable = new StringBuffer();
            ((StringBuffer)serializable).append(TRANSLATION_DOMAIN_PREFIX);
            ((StringBuffer)serializable).append(exception.getClass().getSimpleName());
            for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
                if (!stackTraceElement.getClassName().contains(CODE_DOMAIN)) continue;
                ((StringBuffer)serializable).append(".").append(stackTraceElement.getMethodName());
                break;
            }
            if ((string = SsoAdminUtil.getString(((StringBuffer)serializable).toString(), new String[0])).equals(((StringBuffer)serializable).toString())) {
                string = null;
            }
        }
        if (string == null) {
            serializable = new StringBuffer();
            ((StringBuffer)serializable).append(TRANSLATION_DOMAIN_PREFIX);
            ((StringBuffer)serializable).append(exception.getClass().getSimpleName());
            string = SsoAdminUtil.getString(((StringBuffer)serializable).toString(), new String[0]);
            if (string.equals(((StringBuffer)serializable).toString())) {
                string = null;
            }
        }
        if (string == null) {
            _logger.debug((Object)"Unable to provide error message", (Throwable)exception);
            return null;
        }
        serializable = new SsoBackendException(string);
        return serializable;
    }
}

