/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sso.admin.impl;

import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.type;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vsphere.client.sso.admin.impl.ConfigurationManagementServiceImpl;
import com.vmware.vsphere.client.sso.admin.model.X509RemovalSpec;
import com.vmware.vsphere.client.sso.admin.util.SsoAdminUtil;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigurationManagerMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(ConfigurationManagerMutationProvider.class);
    private final ConfigurationManagementServiceImpl _configManagementService;

    public ConfigurationManagerMutationProvider(SsoService ssoService, ConfigurationManagementServiceImpl configurationManagementServiceImpl) {
        this._configManagementService = configurationManagementServiceImpl;
    }

    @type(value="sso:ConfigurationManager")
    public OperationResult remove(URI uRI, X509RemovalSpec x509RemovalSpec) {
        OperationResult operationResult = new OperationResult();
        try {
            boolean bl = this._configManagementService.deleteTrustedCertificate(x509RemovalSpec.thumbprint);
            operationResult.result = bl;
        }
        catch (Exception exception) {
            _logger.error((Object)"remove(URI, X509RemovalSpec)", (Throwable)exception);
            operationResult.error = SsoAdminUtil.getOperationResultError(exception);
        }
        return operationResult;
    }
}

