/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sso.admin.impl;

import com.vmware.vim.binding.sso.admin.Group;
import com.vmware.vim.binding.sso.admin.PersonUser;
import com.vmware.vim.binding.sso.admin.PrincipalDiscoveryService;
import com.vmware.vim.binding.sso.admin.SolutionUser;
import com.vmware.vim.binding.vim.UserSearchResult;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.security.sso.SsoAdminService;
import com.vmware.vise.vim.security.sso.SsoServiceManager;
import com.vmware.vise.vim.users.DomainSearchResult;
import com.vmware.vise.vim.users.UserDirectorySpec;
import com.vmware.vsphere.client.sso.admin.impl.IdentitySourceDomainManagementService;
import com.vmware.vsphere.client.sso.admin.impl.PrincipalManagementServiceImpl;
import com.vmware.vsphere.client.sso.admin.model.DomainSpec;
import com.vmware.vsphere.client.sso.admin.model.ExternalDomainSpec;
import com.vmware.vsphere.client.sso.admin.model.LocalOSDomainSpec;
import com.vmware.vsphere.client.sso.admin.model.NativeAdDomainSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SsoUserDirectoryPropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(SsoUserDirectoryPropertyProvider.class);
    private SsoServiceManager _ssoMgr = null;

    public SsoUserDirectoryPropertyProvider(SsoServiceManager ssoServiceManager) {
        this._ssoMgr = ssoServiceManager;
    }

    @ModelMetadata(type={"*"}, property="vsphere:domainList")
    public DomainSearchResult[] getDomainList(Object object) throws Exception {
        SsoAdminService ssoAdminService = this._ssoMgr.getSolutionAdminService(object);
        IdentitySourceDomainManagementService identitySourceDomainManagementService = new IdentitySourceDomainManagementService(ssoAdminService);
        List<DomainSpec> list = identitySourceDomainManagementService.getDomains();
        ArrayList<DomainSearchResult> arrayList = new ArrayList<DomainSearchResult>();
        for (DomainSpec domainSpec : list) {
            DomainSearchResult domainSearchResult = new DomainSearchResult(domainSpec.domainName);
            if (domainSpec instanceof ExternalDomainSpec || domainSpec instanceof NativeAdDomainSpec) {
                domainSearchResult.isSystem = false;
            } else if (domainSpec instanceof LocalOSDomainSpec) {
                domainSearchResult.isLocal = true;
            } else {
                domainSearchResult.isSystem = true;
            }
            arrayList.add(domainSearchResult);
        }
        _logger.debug((Object)("getDomainList found " + arrayList.size() + " domains."));
        return (DomainSearchResult[])ArrayUtil.toArray(arrayList, DomainSearchResult.class);
    }

    @ModelMetadata(type={"*"}, property="vsphere:systemDomainList")
    public String[] getSystemDomainsList(Object object) throws Exception {
        SsoAdminService ssoAdminService = this._ssoMgr.getSolutionAdminService(object);
        IdentitySourceDomainManagementService identitySourceDomainManagementService = new IdentitySourceDomainManagementService(ssoAdminService);
        Set<String> set = identitySourceDomainManagementService.getSystemDomains();
        return set.toArray(new String[set.size()]);
    }

    @ModelMetadata(type={"*"}, property="vsphere:userGroups")
    public UserSearchResult[] getUserGroups(Object object, UserDirectorySpec userDirectorySpec) throws Exception {
        UserSearchResult userSearchResult;
        Object[] objectArray;
        if (userDirectorySpec.searchString == null) {
            userDirectorySpec.searchString = "";
        }
        ArrayList<UserSearchResult> arrayList = new ArrayList<UserSearchResult>();
        SsoAdminService ssoAdminService = this._ssoMgr.getSolutionAdminService(object);
        PrincipalManagementServiceImpl principalManagementServiceImpl = new PrincipalManagementServiceImpl(ssoAdminService);
        PrincipalDiscoveryService.SearchResult searchResult = principalManagementServiceImpl.find(userDirectorySpec.domain, userDirectorySpec.searchString);
        if (userDirectorySpec.findUsers) {
            objectArray = searchResult.personUsers;
            for (PersonUser personUser : (PersonUser[])ArrayUtil.toSafe((Object[])objectArray, PersonUser.class)) {
                userSearchResult = new UserSearchResult();
                userSearchResult.principal = personUser.id.name;
                userSearchResult.group = false;
                userSearchResult.fullName = this.getFullName(personUser.details.firstName, personUser.details.lastName);
                arrayList.add(userSearchResult);
            }
            Object[] objectArray2 = searchResult.solutionUsers;
            SolutionUser[] solutionUserArray = (SolutionUser[])ArrayUtil.toSafe((Object[])objectArray2, SolutionUser.class);
            int n = solutionUserArray.length;
            for (int i = 0; i < n; ++i) {
                userSearchResult = solutionUserArray[i];
                UserSearchResult userSearchResult2 = new UserSearchResult();
                userSearchResult2.principal = userSearchResult.id.name;
                userSearchResult2.group = false;
                userSearchResult2.fullName = userSearchResult.details.description;
                arrayList.add(userSearchResult2);
            }
        }
        if (userDirectorySpec.findGroups) {
            objectArray = searchResult.groups;
            for (Group group : (Group[])ArrayUtil.toSafe((Object[])objectArray, Group.class)) {
                userSearchResult = new UserSearchResult();
                userSearchResult.principal = group.id.name;
                userSearchResult.group = true;
                userSearchResult.fullName = group.details.description;
                arrayList.add(userSearchResult);
            }
        }
        if (userDirectorySpec.exactMatch) {
            arrayList = this.filterByPrincipal(arrayList, userDirectorySpec.searchString);
        }
        return (UserSearchResult[])ArrayUtil.toArray(arrayList, UserSearchResult.class);
    }

    private ArrayList<UserSearchResult> filterByPrincipal(ArrayList<UserSearchResult> arrayList, String string) {
        ArrayList<UserSearchResult> arrayList2 = new ArrayList<UserSearchResult>();
        for (UserSearchResult userSearchResult : arrayList) {
            if (!string.equalsIgnoreCase(userSearchResult.principal)) continue;
            arrayList2.add(userSearchResult);
        }
        return arrayList2;
    }

    private String getFullName(String string, String string2) {
        String string3 = "";
        if (!StringUtil.isNullOrEmpty((String)string)) {
            string3 = string3 + string;
        }
        if (!StringUtil.isNullOrEmpty((String)string2)) {
            string3 = string3 + (string3.length() > 0 ? " " + string2 : string2);
        }
        return string3;
    }
}

