/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.spbm.impl;

import com.vmware.vim.binding.pbm.ServiceInstance;
import com.vmware.vim.binding.pbm.ServiceInstanceContent;
import com.vmware.vim.binding.pbm.compliance.ComplianceManager;
import com.vmware.vim.binding.pbm.profile.ProfileManager;
import com.vmware.vim.binding.pbm.replication.ReplicationManager;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.impl.BlockingFuture;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vise.util.feature.FeatureStateService;
import com.vmware.vise.util.feature.names.Feature;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vsphere.client.spbm.PbmService;
import com.vmware.vsphere.client.spbm.impl.PbmServiceUnableToConnectException;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PbmServiceImpl
implements PbmService {
    private static final Log _logger = LogFactory.getLog(PbmServiceImpl.class);
    private static final String SERVICE_INSTANCE_MO_REF_TYPE = "PbmServiceInstance";
    private static final String SERVICE_INSTANCE_MO_REF_ID = "ServiceInstance";
    private Client _vmomiClient;
    private VmodlTypeMap _typeMap;
    private ServiceInstance _serviceInstance;
    private ServiceInstanceContent _serviceInstanceContent;
    private ProfileManager _profileManager;
    private ComplianceManager _complianceManager;
    private ReplicationManager _replicationManager;
    private String[] _supportedFeatures = null;
    private String _vcGuid;
    private FeatureStateService _featureStateService;

    public PbmServiceImpl(Client vmomiClient, String vcGuid, FeatureStateService featureStateService) {
        this._vmomiClient = vmomiClient;
        this._vcGuid = vcGuid;
        this._featureStateService = featureStateService;
        this._typeMap = VmodlTypeMap.Factory.getTypeMap();
    }

    @Override
    public ServiceInstance getServiceInstance() {
        if (this._serviceInstance == null) {
            this._serviceInstance = (ServiceInstance)this.createStub(SERVICE_INSTANCE_MO_REF_TYPE, SERVICE_INSTANCE_MO_REF_ID);
        }
        return this._serviceInstance;
    }

    @Override
    public ServiceInstanceContent getServiceInstanceContent() throws PbmServiceUnableToConnectException {
        if (this._serviceInstanceContent == null) {
            BlockingFuture future = new BlockingFuture();
            this.getServiceInstance().getContent((Future)future);
            try {
                this._serviceInstanceContent = (ServiceInstanceContent)future.get();
            }
            catch (ExecutionException e) {
                throw new PbmServiceUnableToConnectException(e);
            }
            catch (InterruptedException e) {
                throw new PbmServiceUnableToConnectException(e);
            }
        }
        return this._serviceInstanceContent;
    }

    @Override
    public ProfileManager getProfileManager() throws PbmServiceUnableToConnectException {
        if (this._profileManager == null) {
            this._profileManager = (ProfileManager)this.getManagedObject(this.getServiceInstanceContent().profileManager);
        }
        return this._profileManager;
    }

    @Override
    public ReplicationManager getReplicationManager() throws PbmServiceUnableToConnectException {
        if (this._replicationManager == null) {
            this._replicationManager = (ReplicationManager)this.getManagedObject(this.getServiceInstanceContent().replicationManager);
        }
        return this._replicationManager;
    }

    @Override
    public ComplianceManager getComplianceManager() throws PbmServiceUnableToConnectException {
        if (this._complianceManager == null) {
            this._complianceManager = (ComplianceManager)this.getManagedObject(this.getServiceInstanceContent().complianceManager);
        }
        return this._complianceManager;
    }

    @Override
    public <T extends ManagedObject> T getManagedObject(ManagedObjectReference moRef) {
        VmodlType vmodlType = this._typeMap.getVmodlType(moRef.getType());
        Class typeClass = vmodlType.getTypeClass();
        ManagedObject result = this._vmomiClient.createStub(typeClass, moRef);
        return (T)result;
    }

    private <T extends ManagedObject> T createStub(String moRefType, String moRefId) {
        ManagedObjectReference moRef = new ManagedObjectReference(moRefType, moRefId);
        return this.getManagedObject(moRef);
    }

    @Override
    public void logout() {
        try {
            if (this._vmomiClient != null) {
                this._vmomiClient.shutdown();
            }
        }
        catch (Exception ex) {
            _logger.error((Object)("Failed to shutdown vlsi client: " + ex.getMessage()));
        }
    }

    @Override
    public String[] getSupportedFeatures() {
        if (this._supportedFeatures != null) {
            return this._supportedFeatures;
        }
        this._supportedFeatures = VcServiceUtil.isVc61OrLater((String)this._vcGuid) ? (this._featureStateService.isEnabled(Feature.VASA3) ? new String[]{"dataService", "tagNegation"} : new String[0]) : new String[0];
        return this._supportedFeatures;
    }

    @Override
    public boolean isFeatureSupported(String featureId) throws PbmServiceUnableToConnectException {
        if (featureId == null || featureId.isEmpty()) {
            return false;
        }
        String[] supportedFeatures = this.getSupportedFeatures();
        if (supportedFeatures != null) {
            for (String supportedFeatureId : supportedFeatures) {
                if (!featureId.equalsIgnoreCase(supportedFeatureId)) continue;
                return true;
            }
        }
        return false;
    }
}

