/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.spbm.impl;

import com.vmware.vim.binding.pbm.capability.CapabilityInstance;
import com.vmware.vim.binding.pbm.capability.provider.CapabilityObjectSchema;
import com.vmware.vim.binding.pbm.profile.CapabilityBasedProfile;
import com.vmware.vim.binding.pbm.profile.Profile;
import com.vmware.vim.binding.pbm.profile.ProfileId;
import com.vmware.vim.binding.pbm.profile.ProfileManager;
import com.vmware.vim.binding.pbm.profile.ResourceType;
import com.vmware.vim.binding.pbm.profile.SubProfileCapabilityConstraints;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.impl.BlockingFuture;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataProviderAdapter;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.ResultItemComparator;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.security.LegacyAuthorizationService;
import com.vmware.vsphere.client.spbm.PbmService;
import com.vmware.vsphere.client.spbm.PbmServiceFactory;
import com.vmware.vsphere.client.spbm.util.ManagedUtil;
import com.vmware.vsphere.client.spbm.util.MetadataUtil;
import com.vmware.vsphere.client.spbm.util.PbmSessionUtil;
import com.vmware.vsphere.client.spbm.util.PbmUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@type(value="PbmRequirementStorageProfile,PbmCapabilityStorageProfile,PbmDataServiceStorageProfile")
public class ProfileProviderAdapter
implements DataProviderAdapter {
    private static final String NAME_PROPERTY = "name";
    private static final String DESCRIPTION_PROPERTY = "description";
    private static final String CREATE_TIME_PROPERTY = "createdTime";
    private static final String EDIT_TIME_PROPERTY = "modifiedTime";
    private static final String PROFILE_CONTENT_PROPERTY = "profileContent";
    private static final String PROFILE_VC_NAME_PROPERTY = "vCenterName";
    private static final String IS_SYSTEM_CREATED_PROFILE_PROPERTY = "isSystemCreatedProfile";
    private static final String IS_VSAN_SYSTEM_CREATED_PROFILE_PROPERTY = "isVsanSystemCreatedProfile";
    private static final String IS_VVOL_SYSTEM_CREATED_PROFILE_PROPERTY = "isVvolSystemCreatedProfile";
    private static final String LINE_OF_SERVICE_PROFILE_PROPERTY = "lineOfService";
    private static final String DATA_SERVICE_PROFILE_OWNER_PROPERTY = "owner";
    private static final String PBM_PROFILE_RELATION = "pbmProfiles";
    private static final String VIRTUAL_CENTER_TYPE = "Folder";
    private static final Log _logger = LogFactory.getLog(ProfileProviderAdapter.class);
    private LegacyAuthorizationService _authorizationService;
    private PbmServiceFactory _pbmServiceFactory;

    public ProfileProviderAdapter(PbmServiceFactory pbmServiceFactory, LegacyAuthorizationService authorizationService) {
        this._pbmServiceFactory = pbmServiceFactory;
        this._authorizationService = authorizationService;
    }

    public Response getData(RequestSpec request) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{request});
        QuerySpec[] querySpecs = request.querySpec;
        ResultSet[] resultSets = new ResultSet[querySpecs.length];
        for (int i = 0; i < querySpecs.length; ++i) {
            resultSets[i] = this.processQuery(querySpecs[i]);
        }
        Response response = new Response();
        response.resultSet = resultSets;
        return response;
    }

    private ResultSet processQuery(QuerySpec querySpec) {
        ResultSet resultSet = new ResultSet();
        try {
            URI[] profiles = null;
            Object[] identityConstraints = ProfileProviderAdapter.getObjectIdentityConstraints(querySpec.resourceSpec.constraint);
            ResourceType resourceType = ManagedUtil.getResourceTypeByProfileType(querySpec.resourceSpec.constraint.targetType);
            CapabilityBasedProfile.ProfileCategoryEnum profileCategory = ManagedUtil.getProfileCategory(querySpec.resourceSpec.constraint.targetType);
            if (!ArrayUtil.isNullOrEmpty((Object[])identityConstraints)) {
                profiles = new URI[identityConstraints.length];
                for (int i = 0; i < identityConstraints.length; ++i) {
                    profiles[i] = (URI)((ObjectIdentityConstraint)identityConstraints[i]).target;
                }
            } else if (querySpec.resourceSpec.constraint instanceof RelationalConstraint) {
                RelationalConstraint rc = (RelationalConstraint)querySpec.resourceSpec.constraint;
                if (PBM_PROFILE_RELATION.equals(rc.relation) && rc.constraintOnRelatedObject instanceof ObjectIdentityConstraint) {
                    ObjectIdentityConstraint relatedEntityConstraint = (ObjectIdentityConstraint)rc.constraintOnRelatedObject;
                    profiles = this.getRelatedProfilesForEntity(relatedEntityConstraint.target, resourceType, profileCategory);
                }
            } else {
                profiles = this.getProfilesForResourceType(resourceType, profileCategory);
            }
            if (profiles != null) {
                FilterData filterData = ProfileProviderAdapter.getFilterData(querySpec.resourceSpec.constraint);
                resultSet = this.getPropertySet(profiles, querySpec.resourceSpec.propertySpecs, filterData, resourceType);
            }
        }
        catch (Exception e) {
            resultSet.error = PbmUtil.getMethodFault(e);
        }
        resultSet.queryName = querySpec.name;
        resultSet.totalMatchedObjectCount = resultSet.items != null ? resultSet.items.length : 0;
        try {
            if (resultSet.items != null && querySpec.resultSpec != null && querySpec.resultSpec.order != null && querySpec.resultSpec.order != Utils.DEFAULT_ORDERING_CRITERIA) {
                Arrays.sort(resultSet.items, new ResultItemComparator(querySpec.resultSpec.order));
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed to sort profiles: ", (Throwable)ex);
        }
        if (resultSet.items != null && querySpec.resultSpec != null) {
            ResultItem[] allResults = resultSet.items;
            int startIndex = 0;
            if (querySpec.resultSpec.offset != null && querySpec.resultSpec.offset >= 0) {
                startIndex = querySpec.resultSpec.offset;
            }
            int maxResultCount = allResults.length - startIndex;
            if (querySpec.resultSpec.maxResultCount != null && querySpec.resultSpec.maxResultCount >= 0) {
                maxResultCount = Math.min(maxResultCount, querySpec.resultSpec.maxResultCount);
            }
            if (startIndex >= allResults.length || maxResultCount == 0) {
                resultSet.items = new ResultItem[0];
            } else if (startIndex != 0 || maxResultCount != allResults.length) {
                resultSet.items = Arrays.copyOfRange(allResults, startIndex, startIndex + maxResultCount);
            }
        }
        return resultSet;
    }

    private static ObjectIdentityConstraint[] getObjectIdentityConstraints(Constraint constraint) {
        if (constraint instanceof ObjectIdentityConstraint) {
            return new ObjectIdentityConstraint[]{(ObjectIdentityConstraint)constraint};
        }
        if (constraint instanceof CompositeConstraint) {
            CompositeConstraint compositeConstraint = (CompositeConstraint)constraint;
            if (!ArrayUtil.isNullOrEmpty((Object[])compositeConstraint.nestedConstraints)) {
                ArrayList<ObjectIdentityConstraint> results = new ArrayList<ObjectIdentityConstraint>();
                for (Constraint constraintItem : compositeConstraint.nestedConstraints) {
                    if (!(constraintItem instanceof ObjectIdentityConstraint)) continue;
                    ObjectIdentityConstraint objIdConstraint = (ObjectIdentityConstraint)constraintItem;
                    if (objIdConstraint.target == null || !ManagedUtil.isProfileObject(objIdConstraint.target)) continue;
                    results.add(objIdConstraint);
                }
                return results.toArray(new ObjectIdentityConstraint[0]);
            }
        }
        return null;
    }

    private static FilterData getFilterData(Constraint constraint) {
        FilterData result = null;
        if (constraint instanceof CompositeConstraint) {
            CompositeConstraint compositeConstraint = (CompositeConstraint)constraint;
            if (Conjoiner.AND.equals((Object)compositeConstraint.conjoiner) && compositeConstraint.nestedConstraints != null && compositeConstraint.nestedConstraints.length == 2) {
                CompositeConstraint nestedPropertyConstraints = null;
                if (compositeConstraint.nestedConstraints[0] instanceof CompositeConstraint) {
                    nestedPropertyConstraints = (CompositeConstraint)compositeConstraint.nestedConstraints[0];
                }
                if (compositeConstraint.nestedConstraints[1] instanceof CompositeConstraint) {
                    nestedPropertyConstraints = (CompositeConstraint)compositeConstraint.nestedConstraints[1];
                }
                if (nestedPropertyConstraints != null && Conjoiner.OR.equals((Object)nestedPropertyConstraints.conjoiner) && !ArrayUtil.isNullOrEmpty((Object[])nestedPropertyConstraints.nestedConstraints)) {
                    for (Constraint nestedConstraint : nestedPropertyConstraints.nestedConstraints) {
                        String filterString;
                        if (!(nestedConstraint instanceof PropertyConstraint)) continue;
                        PropertyConstraint propertyConstraint = (PropertyConstraint)nestedConstraint;
                        if (!Comparator.TEXTUALLY_MATCHES.equals((Object)propertyConstraint.comparator) || !(propertyConstraint.comparableValue instanceof String) || (filterString = (String)propertyConstraint.comparableValue) == null || filterString.trim().length() <= 0) continue;
                        if (result == null) {
                            result = new FilterData();
                        }
                        result.filterString = filterString.toLowerCase().trim();
                        result.propertyNames.add(propertyConstraint.propertyName);
                    }
                }
            }
        }
        return result;
    }

    private URI[] getProfilesForResourceType(ResourceType resourceType, CapabilityBasedProfile.ProfileCategoryEnum profileCategory) {
        ArrayList<URI> profiles = new ArrayList<URI>();
        LinkedVcGroupRegistry vcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry();
        LinkedVcGroup[] linkedVcGroups = vcGroupRegistry.getUtils().getStartupLinkedVcGroups();
        if (linkedVcGroups == null) {
            return new URI[0];
        }
        for (LinkedVcGroup linkedVcGroup : linkedVcGroups) {
            for (VcService vcService : linkedVcGroup.getVcServices()) {
                if (vcService.getConnectionInfo().getErrorCode() != "noError") continue;
                try {
                    this.getProfilesForVc(resourceType, profileCategory, vcService.getServiceGuid(), profiles);
                }
                catch (Exception ex) {
                    _logger.error((Object)("Failed to load profiles for VC: " + ex.getMessage()));
                }
            }
        }
        return profiles.toArray(new URI[0]);
    }

    private URI[] getRelatedProfilesForEntity(Object entity, ResourceType resourceType, CapabilityBasedProfile.ProfileCategoryEnum profileCategory) throws Exception {
        ArrayList<URI> profiles = new ArrayList<URI>();
        if (entity instanceof ManagedObjectReference && VIRTUAL_CENTER_TYPE.equals(((ManagedObjectReference)entity).getType())) {
            this.getProfilesForVc(resourceType, profileCategory, ((ManagedObjectReference)entity).getServerGuid(), profiles);
        } else if (entity instanceof URI && "PbmDataServiceStorageProfile".equals(ManagedUtil.getProfileTypeByUri((URI)entity))) {
            this.getParentProfiles(resourceType, profileCategory, (URI)entity, profiles);
        }
        return profiles.toArray(new URI[profiles.size()]);
    }

    private void getParentProfiles(ResourceType resourceType, CapabilityBasedProfile.ProfileCategoryEnum profileCategory, URI dataServiceProfile, ArrayList<URI> profiles) throws Exception {
        String vcServiceGuid = ManagedUtil.getVcGuid(dataServiceProfile);
        ProfileId dataServiceProfileId = ManagedUtil.uriToProfileId(dataServiceProfile);
        PbmService pbmService = PbmSessionUtil.getService(vcServiceGuid, this._pbmServiceFactory);
        ProfileId[] parentProfileIds = PbmUtil.getParentProfileId(pbmService.getProfileManager(), dataServiceProfileId);
        if (parentProfileIds == null) {
            return;
        }
        for (ProfileId profileId : parentProfileIds) {
            profiles.add(ManagedUtil.buildProfileUri(resourceType, profileCategory, vcServiceGuid, profileId));
        }
    }

    private void getProfilesForVc(ResourceType resourceType, CapabilityBasedProfile.ProfileCategoryEnum profileCategory, String vcGuid, ArrayList<URI> profiles) throws Exception {
        if (!PbmUtil.hasSpbmViewPrivilege(this._authorizationService, vcGuid)) {
            return;
        }
        PbmService pbmService = PbmSessionUtil.getService(vcGuid, this._pbmServiceFactory);
        if (CapabilityBasedProfile.ProfileCategoryEnum.DATA_SERVICE_POLICY == profileCategory && !pbmService.isFeatureSupported("dataService")) {
            return;
        }
        BlockingFuture future = new BlockingFuture();
        ProfileManager profileManager = pbmService.getProfileManager();
        profileManager.queryProfile(resourceType, profileCategory.toString(), (Future)future);
        ProfileId[] profileIds = (ProfileId[])future.get();
        if (profileIds == null) {
            return;
        }
        for (ProfileId profileId : profileIds) {
            profiles.add(ManagedUtil.buildProfileUri(resourceType, profileCategory, vcGuid, profileId));
        }
    }

    private ResultSet getPropertySet(URI[] profileUris, PropertySpec[] properties, FilterData filterData, ResourceType resourceType) {
        ResultSet result = new ResultSet();
        if (profileUris == null || profileUris.length == 0) {
            return result;
        }
        ArrayList<ResultItem> items = new ArrayList<ResultItem>();
        try {
            if (ProfileProviderAdapter.emptyPropertySpecs(properties)) {
                for (URI profileUri : profileUris) {
                    items.add(this.buildResultItem(null, profileUri, properties, null));
                }
            } else {
                Map<String, List<URI>> profilesByGuid = ManagedUtil.getProfilesByServerGuid(profileUris);
                Set<String> serverGuids = profilesByGuid.keySet();
                boolean retrieveNamespaceOwners = ProfileProviderAdapter.containsOwnerProperty(properties);
                for (String vcServerGuid : serverGuids) {
                    List<URI> profileUriList = profilesByGuid.get(vcServerGuid);
                    Object[] profiles = this.getProfileContent(profileUriList, vcServerGuid);
                    if (ArrayUtil.isNullOrEmpty((Object[])profiles)) continue;
                    Map<String, String> namespaceOwners = null;
                    if (retrieveNamespaceOwners) {
                        namespaceOwners = this.retrieveNamespaceOwnersMap(vcServerGuid, resourceType);
                    }
                    for (URI profileUri : profileUriList) {
                        Profile profile = this.findProfileByUri((Profile[])profiles, profileUri);
                        ResultItem profileItem = this.buildResultItem(profile, profileUri, properties, namespaceOwners);
                        if (!ProfileProviderAdapter.textuallyMatches(profileItem, filterData)) continue;
                        items.add(profileItem);
                    }
                }
            }
        }
        catch (Exception ex) {
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        result.items = items.toArray(new ResultItem[items.size()]);
        return result;
    }

    private static boolean emptyPropertySpecs(PropertySpec[] propertySpecs) {
        if (propertySpecs == null || propertySpecs.length == 0) {
            return true;
        }
        for (PropertySpec propertySpec : propertySpecs) {
            if (propertySpec == null || propertySpec.propertyNames == null || propertySpec.propertyNames.length <= 0) continue;
            return false;
        }
        return true;
    }

    private static boolean containsOwnerProperty(PropertySpec[] propertySpecs) {
        if (ArrayUtil.isNullOrEmpty((Object[])propertySpecs)) {
            return false;
        }
        for (PropertySpec propertySpec : propertySpecs) {
            if (propertySpec == null || propertySpec.propertyNames == null) continue;
            for (String propertyName : propertySpec.propertyNames) {
                if (!DATA_SERVICE_PROFILE_OWNER_PROPERTY.equals(propertyName)) continue;
                return true;
            }
        }
        return false;
    }

    private Map<String, String> retrieveNamespaceOwnersMap(String vcServerGuid, ResourceType resourceType) throws Exception {
        PbmService pbmService = PbmSessionUtil.getService(vcServerGuid, this._pbmServiceFactory);
        List<CapabilityObjectSchema.NamespaceInfo> namespaceInfos = MetadataUtil.getNamespaceInfo(pbmService, resourceType);
        HashMap<String, String> result = new HashMap<String, String>();
        if (namespaceInfos != null) {
            for (CapabilityObjectSchema.NamespaceInfo namespaceInfo : namespaceInfos) {
                result.put(namespaceInfo.namespace, namespaceInfo.owner);
            }
        }
        return result;
    }

    private static String getSystemCreatedProfileType(Profile profile) {
        if (profile != null && profile instanceof CapabilityBasedProfile) {
            return ((CapabilityBasedProfile)profile).systemCreatedProfileType;
        }
        return null;
    }

    private static boolean textuallyMatches(ResultItem item, FilterData filterData) {
        if (filterData == null) {
            return true;
        }
        if (item.properties == null) {
            return false;
        }
        for (PropertyValue propVal : item.properties) {
            String value;
            if (!filterData.propertyNames.contains(propVal.propertyName) || propVal.value == null || !(propVal.value instanceof String) || (value = (String)propVal.value).toLowerCase().indexOf(filterData.filterString) < 0) continue;
            return true;
        }
        return false;
    }

    private Profile findProfileByUri(Profile[] profiles, URI profileUri) {
        String profileId = ManagedUtil.getProfileUid(profileUri);
        for (Profile profile : profiles) {
            if (profile == null || profile.profileId == null || profile.profileId.uniqueId == null || !profile.profileId.uniqueId.equals(profileId)) continue;
            return profile;
        }
        return null;
    }

    private Profile[] getProfileContent(List<URI> profileUriList, String vcServerGuid) throws Exception {
        PbmService pbmService = PbmSessionUtil.getService(vcServerGuid, this._pbmServiceFactory);
        if (pbmService == null) {
            return null;
        }
        BlockingFuture future = new BlockingFuture();
        pbmService.getProfileManager().retrieveContent(ManagedUtil.uriListToProfileId(profileUriList), (Future)future);
        return (Profile[])future.get();
    }

    private ResultItem buildResultItem(Profile profile, URI profileUri, PropertySpec[] propertySpecs, Map<String, String> namespaceOwners) {
        ArrayList<PropertyValue> propertyValues = new ArrayList<PropertyValue>();
        if (propertySpecs != null && profile != null) {
            for (PropertySpec propertySpec : propertySpecs) {
                for (String property : propertySpec.propertyNames) {
                    String systemCreatedType;
                    if (NAME_PROPERTY.equals(property)) {
                        propertyValues.add(this.buildPropertyValue(NAME_PROPERTY, profile.name, profileUri));
                        continue;
                    }
                    if (PROFILE_CONTENT_PROPERTY.equals(property)) {
                        propertyValues.add(this.buildPropertyValue(PROFILE_CONTENT_PROPERTY, profile, profileUri));
                        continue;
                    }
                    if (DESCRIPTION_PROPERTY.equals(property)) {
                        propertyValues.add(this.buildPropertyValue(DESCRIPTION_PROPERTY, profile.description, profileUri));
                        continue;
                    }
                    if (CREATE_TIME_PROPERTY.equals(property)) {
                        propertyValues.add(this.buildPropertyValue(CREATE_TIME_PROPERTY, profile.creationTime, profileUri));
                        continue;
                    }
                    if (EDIT_TIME_PROPERTY.equals(property)) {
                        propertyValues.add(this.buildPropertyValue(EDIT_TIME_PROPERTY, profile.lastUpdatedTime, profileUri));
                        continue;
                    }
                    if (PROFILE_VC_NAME_PROPERTY.equals(property)) {
                        String vcServiceGuid = ManagedUtil.getVcGuid(profileUri);
                        String vcName = VcServiceUtil.getServiceName((String)vcServiceGuid);
                        propertyValues.add(this.buildPropertyValue(PROFILE_VC_NAME_PROPERTY, vcName, profileUri));
                        continue;
                    }
                    if (IS_SYSTEM_CREATED_PROFILE_PROPERTY.equals(property)) {
                        systemCreatedType = ProfileProviderAdapter.getSystemCreatedProfileType(profile);
                        boolean isSystemCreated = systemCreatedType != null && !systemCreatedType.isEmpty();
                        propertyValues.add(this.buildPropertyValue(IS_SYSTEM_CREATED_PROFILE_PROPERTY, isSystemCreated, profileUri));
                        continue;
                    }
                    if (IS_VSAN_SYSTEM_CREATED_PROFILE_PROPERTY.equals(property)) {
                        systemCreatedType = ProfileProviderAdapter.getSystemCreatedProfileType(profile);
                        boolean isVsanSystemCreated = CapabilityBasedProfile.SystemCreatedProfileType.VsanDefaultProfile.toString().equals(systemCreatedType);
                        propertyValues.add(this.buildPropertyValue(IS_VSAN_SYSTEM_CREATED_PROFILE_PROPERTY, isVsanSystemCreated, profileUri));
                        continue;
                    }
                    if (IS_VVOL_SYSTEM_CREATED_PROFILE_PROPERTY.equals(property)) {
                        systemCreatedType = ProfileProviderAdapter.getSystemCreatedProfileType(profile);
                        boolean isVvolSystemCreated = CapabilityBasedProfile.SystemCreatedProfileType.VVolDefaultProfile.toString().equals(systemCreatedType);
                        propertyValues.add(this.buildPropertyValue(IS_VVOL_SYSTEM_CREATED_PROFILE_PROPERTY, isVvolSystemCreated, profileUri));
                        continue;
                    }
                    if (LINE_OF_SERVICE_PROFILE_PROPERTY.equals(property)) {
                        if (profile instanceof CapabilityBasedProfile) {
                            propertyValues.add(this.buildPropertyValue(LINE_OF_SERVICE_PROFILE_PROPERTY, ((CapabilityBasedProfile)profile).lineOfService, profileUri));
                            continue;
                        }
                        propertyValues.add(this.buildPropertyValue(LINE_OF_SERVICE_PROFILE_PROPERTY, null, profileUri));
                        continue;
                    }
                    if (!DATA_SERVICE_PROFILE_OWNER_PROPERTY.equals(property)) continue;
                    String owner = ProfileProviderAdapter.getOwnerProperty(profile, namespaceOwners);
                    propertyValues.add(this.buildPropertyValue(DATA_SERVICE_PROFILE_OWNER_PROPERTY, owner, profileUri));
                }
            }
        }
        ResultItem resultItem = new ResultItem();
        resultItem.resourceObject = profileUri;
        resultItem.properties = propertyValues.toArray(new PropertyValue[0]);
        return resultItem;
    }

    private static String getOwnerProperty(Profile profile, Map<String, String> namespaceOwners) {
        if (!(profile instanceof CapabilityBasedProfile) || namespaceOwners == null) {
            return null;
        }
        String owner = null;
        CapabilityBasedProfile capabilityBasedProfile = (CapabilityBasedProfile)profile;
        if (capabilityBasedProfile == null || !(capabilityBasedProfile.constraints instanceof SubProfileCapabilityConstraints)) {
            return null;
        }
        SubProfileCapabilityConstraints constraints = (SubProfileCapabilityConstraints)capabilityBasedProfile.constraints;
        if (constraints == null || constraints.subProfiles == null) {
            return owner;
        }
        for (SubProfileCapabilityConstraints.SubProfile subProfile : constraints.subProfiles) {
            if (subProfile == null || subProfile.capability == null) continue;
            for (CapabilityInstance capability : subProfile.capability) {
                if (capability == null || capability.id == null) continue;
                String capabilityOwner = namespaceOwners.get(capability.id.namespace);
                if (capabilityOwner == null || "spbmDataDrivenUI".equals(capabilityOwner)) {
                    owner = "spbmDataDrivenUI";
                    continue;
                }
                if (capabilityOwner == null || capabilityOwner.isEmpty()) continue;
                return capabilityOwner;
            }
        }
        return owner;
    }

    private PropertyValue buildPropertyValue(String propertyName, Object propertyValue, URI profile) {
        PropertyValue pv = new PropertyValue();
        pv.resourceObject = profile;
        pv.propertyName = propertyName;
        pv.value = propertyValue;
        return pv;
    }

    private static class FilterData {
        public String filterString;
        public ArrayList<String> propertyNames = new ArrayList();

        private FilterData() {
        }
    }
}

