/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.spbm.impl;

import com.vmware.vim.binding.pbm.ServerObjectRef;
import com.vmware.vim.binding.pbm.replication.QueryReplicationGroupResult;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.vm.replication.ReplicationGroupId;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vsphere.client.common.spbm.data.ReplicationGroupAssignmentInfo;
import com.vmware.vsphere.client.common.spbm.data.ReplicationGroupInfo;
import com.vmware.vsphere.client.spbm.PbmService;
import com.vmware.vsphere.client.spbm.PbmServiceFactory;
import com.vmware.vsphere.client.spbm.util.ManagedUtil;
import com.vmware.vsphere.client.spbm.util.PbmSessionUtil;
import com.vmware.vsphere.client.spbm.util.PbmUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmReplicationGroupPropertyProviderAdapter
implements PropertyProviderAdapter {
    private static final Log _logger = LogFactory.getLog(VmReplicationGroupPropertyProviderAdapter.class);
    private static final String VM_REPLICATION_GROUP_PROPERTY = "vmReplicationGroupAssignments";
    private final PbmServiceFactory _pbmServiceFactory;
    private final QueryExecutor _queryExecutor;
    private final QuerySpecBuilder _querySpecBuilder;

    public VmReplicationGroupPropertyProviderAdapter(PbmServiceFactory pbmServiceFactory, DataServiceExtensionRegistry registry, QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder) {
        this._pbmServiceFactory = pbmServiceFactory;
        this._queryExecutor = queryExecutor;
        this._querySpecBuilder = querySpecBuilder;
        registry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo ti = new TypeInfo();
        ti.type = VirtualMachine.class.getSimpleName();
        ti.properties = new String[]{VM_REPLICATION_GROUP_PROPERTY};
        return new TypeInfo[]{ti};
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{propertyRequest});
        Object[] objects = propertyRequest.objects;
        PropertySpec[] properties = propertyRequest.properties;
        ResultSet resultSet = new ResultSet();
        if (properties == null || !this.containsProperty(properties, VM_REPLICATION_GROUP_PROPERTY)) {
            resultSet.items = new ResultItem[0];
            return resultSet;
        }
        HashMap<ManagedObjectReference, List<ReplicationGroupAssignmentInfo>> vmReplicationGroupAssignments = null;
        try {
            vmReplicationGroupAssignments = this.getVmReplicationGroupAssignments(objects);
        }
        catch (Exception ex) {
            return this.createErrorResult(ex);
        }
        if (vmReplicationGroupAssignments == null) {
            resultSet.items = new ResultItem[0];
            return resultSet;
        }
        ArrayList<ResultItem> resultItems = new ArrayList<ResultItem>();
        for (ManagedObjectReference vmRef : vmReplicationGroupAssignments.keySet()) {
            resultItems.add(this.newResultItem(vmRef, (List)vmReplicationGroupAssignments.get(vmRef)));
        }
        resultSet.items = resultItems.toArray(new ResultItem[resultItems.size()]);
        return resultSet;
    }

    private ResultItem newResultItem(ManagedObjectReference vmRef, List<ReplicationGroupAssignmentInfo> replicationGroupAssignments) {
        ResultItem resultItem = new ResultItem();
        resultItem.resourceObject = vmRef;
        resultItem.properties = new PropertyValue[]{this.createPropValue(VM_REPLICATION_GROUP_PROPERTY, replicationGroupAssignments, vmRef)};
        return resultItem;
    }

    private boolean containsProperty(PropertySpec[] propertySpecArray, String propertyName) {
        for (PropertySpec propertySpec : propertySpecArray) {
            for (String property : propertySpec.propertyNames) {
                if (!propertyName.equals(property)) continue;
                return true;
            }
        }
        return false;
    }

    private HashMap<ManagedObjectReference, List<ReplicationGroupAssignmentInfo>> getVmReplicationGroupAssignments(Object[] vms) throws Exception {
        try {
            HashMap<ManagedObjectReference, List<ReplicationGroupAssignmentInfo>> result = new HashMap<ManagedObjectReference, List<ReplicationGroupAssignmentInfo>>();
            Map<String, ArrayList<ManagedObjectReference>> vmsByGuid = ManagedUtil.groupMoRefsByVcGuid(vms);
            if (vmsByGuid.size() == 0) {
                return result;
            }
            for (String vcGuid : vmsByGuid.keySet()) {
                PbmService service = PbmSessionUtil.getService(vcGuid, this._pbmServiceFactory);
                if (service == null || !service.isFeatureSupported("dataService")) continue;
                ManagedObjectReference[] vmRefs = vmsByGuid.get(vcGuid).toArray(new ManagedObjectReference[0]);
                ServerObjectRef[] vmAndDiskSor = VmReplicationGroupPropertyProviderAdapter.vmMorToVmAndDiskSor(vmRefs);
                QueryReplicationGroupResult[] rgResults = null;
                try {
                    rgResults = service.getReplicationManager().queryReplicationGroups(vmAndDiskSor);
                }
                catch (Exception ex) {
                    _logger.error((Object)"Failed to invoke ReplicationManager.queryReplicationGroups()!", (Throwable)ex);
                }
                if (rgResults == null) continue;
                ArrayList<ReplicationGroupId> replicationGroupIds = new ArrayList<ReplicationGroupId>();
                for (QueryReplicationGroupResult rgResult : rgResults) {
                    if (rgResult == null || rgResult.replicationGroupId == null) continue;
                    replicationGroupIds.add(rgResult.replicationGroupId);
                }
                ManagedObjectReference vcRef = ManagedUtil.buildVcMoRef(vcGuid);
                ReplicationGroupInfo[] replicationGroupInfos = PbmUtil.getReplicationGroupInfos(replicationGroupIds, vcRef, this._queryExecutor, this._querySpecBuilder);
                HashMap<String, ReplicationGroupInfo> replicationGroupInfoMap = new HashMap<String, ReplicationGroupInfo>();
                if (replicationGroupInfos != null) {
                    for (ReplicationGroupInfo replicationGroupInfo : replicationGroupInfos) {
                        replicationGroupInfoMap.put(PbmUtil.replicationGroupIdAsString(replicationGroupInfo.id), replicationGroupInfo);
                    }
                }
                for (ReplicationGroupInfo replicationGroupInfo : rgResults) {
                    ManagedObjectReference vmRef = ManagedUtil.serverObjectRefToVmMor(replicationGroupInfo.object, vcGuid);
                    if (vmRef == null) continue;
                    if (!result.containsKey(vmRef)) {
                        result.put(vmRef, new ArrayList());
                    }
                    result.get(vmRef).add(VmReplicationGroupPropertyProviderAdapter.queryRgResultToRgAssignmentInfo((QueryReplicationGroupResult)replicationGroupInfo, replicationGroupInfoMap));
                }
            }
            return result;
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed to retrieve replication group assignments: ", (Throwable)ex);
            throw PbmUtil.getMethodFault(ex);
        }
    }

    private static ReplicationGroupAssignmentInfo queryRgResultToRgAssignmentInfo(QueryReplicationGroupResult qRgResult, HashMap<String, ReplicationGroupInfo> rgInfoMap) {
        ReplicationGroupAssignmentInfo result = new ReplicationGroupAssignmentInfo();
        result.fault = qRgResult.fault;
        result.vmObjectId = qRgResult.object.key;
        if (qRgResult.replicationGroupId != null) {
            String rgIdKey = PbmUtil.replicationGroupIdAsString(qRgResult.replicationGroupId);
            if (rgInfoMap.containsKey(rgIdKey)) {
                result.replicationGroup = rgInfoMap.get(rgIdKey);
            } else {
                result.replicationGroup = new ReplicationGroupInfo();
                result.replicationGroup.id = qRgResult.replicationGroupId;
            }
        }
        return result;
    }

    private static ServerObjectRef[] vmMorToVmAndDiskSor(ManagedObjectReference[] vmRefs) {
        ServerObjectRef[] result = ManagedUtil.managedObjectRefToServerObjectRef(vmRefs);
        if (result != null) {
            for (ServerObjectRef sor : result) {
                sor.objectType = ServerObjectRef.ObjectType.virtualMachineAndDisks.toString();
            }
        }
        return result;
    }

    private ResultSet createErrorResult(Exception fault) {
        ResultSet resultSet = new ResultSet();
        resultSet.error = fault;
        return resultSet;
    }

    private PropertyValue createPropValue(String name, Object value, Object provider) {
        PropertyValue propValue = new PropertyValue();
        propValue.propertyName = name;
        propValue.value = value;
        propValue.resourceObject = provider;
        return propValue;
    }
}

