/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.event;

import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.lang.reflect.Array;
import java.util.EventListener;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.TextNode;
import org.apache.batik.gvt.event.EventDispatcher;
import org.apache.batik.gvt.event.GraphicsNodeKeyEvent;
import org.apache.batik.gvt.event.GraphicsNodeKeyListener;
import org.apache.batik.gvt.event.GraphicsNodeMouseEvent;
import org.apache.batik.gvt.event.GraphicsNodeMouseListener;

public class AWTEventDispatcher
implements EventDispatcher,
MouseListener,
MouseMotionListener,
KeyListener {
    protected GraphicsNode root;
    protected AffineTransform baseTransform;
    protected EventListenerList glisteners;
    protected GraphicsNode lastHit;
    protected GraphicsNode dummyNode = new TextNode();
    protected GraphicsNode currentKeyEventTarget;
    protected List eventQueue = new LinkedList();
    protected boolean eventDispatchEnabled = true;
    protected int eventQueueMaxSize = 10;
    static final int MAX_QUEUE_SIZE = 10;
    private int nodeIncrementEventID = 401;
    private int nodeIncrementEventCode = 9;
    private int nodeIncrementEventModifiers = 0;
    private int nodeDecrementEventID = 401;
    private int nodeDecrementEventCode = 9;
    private int nodeDecrementEventModifiers = 1;

    public void setRootNode(GraphicsNode graphicsNode) {
        if (this.root != graphicsNode) {
            this.eventQueue.clear();
        }
        this.root = graphicsNode;
    }

    public GraphicsNode getRootNode() {
        return this.root;
    }

    public void setBaseTransform(AffineTransform affineTransform) {
        if (!(this.baseTransform == affineTransform || this.baseTransform != null && this.baseTransform.equals(affineTransform))) {
            this.eventQueue.clear();
        }
        this.baseTransform = affineTransform;
    }

    public AffineTransform getBaseTransform() {
        return new AffineTransform(this.baseTransform);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent);
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.dispatchEvent(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.dispatchEvent(keyEvent);
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.dispatchEvent(keyEvent);
    }

    public void addGraphicsNodeMouseListener(GraphicsNodeMouseListener graphicsNodeMouseListener) {
        if (this.glisteners == null) {
            this.glisteners = new EventListenerList();
        }
        this.glisteners.add(GraphicsNodeMouseListener.class, graphicsNodeMouseListener);
    }

    public void removeGraphicsNodeMouseListener(GraphicsNodeMouseListener graphicsNodeMouseListener) {
        if (this.glisteners != null) {
            this.glisteners.remove(GraphicsNodeMouseListener.class, graphicsNodeMouseListener);
        }
    }

    public void addGraphicsNodeKeyListener(GraphicsNodeKeyListener graphicsNodeKeyListener) {
        if (this.glisteners == null) {
            this.glisteners = new EventListenerList();
        }
        this.glisteners.add(GraphicsNodeKeyListener.class, graphicsNodeKeyListener);
    }

    public void removeGraphicsNodeKeyListener(GraphicsNodeKeyListener graphicsNodeKeyListener) {
        if (this.glisteners != null) {
            this.glisteners.remove(GraphicsNodeKeyListener.class, graphicsNodeKeyListener);
        }
    }

    public EventListener[] getListeners(Class clazz) {
        Object object = Array.newInstance(clazz, this.glisteners.getListenerCount(clazz));
        Object[] objectArray = this.glisteners.getListenerList();
        int n = 0;
        for (int i = 0; i < objectArray.length - 1; i += 2) {
            if (!objectArray[i].equals(clazz)) continue;
            Array.set(object, n, objectArray[i + 1]);
            ++n;
        }
        return (EventListener[])object;
    }

    public void setEventDispatchEnabled(boolean bl) {
        this.eventDispatchEnabled = bl;
        if (this.eventDispatchEnabled) {
            while (this.eventQueue.size() > 0) {
                EventObject eventObject = (EventObject)this.eventQueue.remove(0);
                this.dispatchEvent(eventObject);
            }
        }
    }

    public void setEventQueueMaxSize(int n) {
        this.eventQueueMaxSize = n;
        if (n == 0) {
            this.eventQueue.clear();
        }
        while (this.eventQueue.size() > this.eventQueueMaxSize) {
            this.eventQueue.remove(0);
        }
    }

    public void dispatchEvent(EventObject eventObject) {
        if (this.root == null) {
            return;
        }
        if (!this.eventDispatchEnabled) {
            if (this.eventQueueMaxSize > 0) {
                this.eventQueue.add(eventObject);
                while (this.eventQueue.size() > this.eventQueueMaxSize) {
                    this.eventQueue.remove(0);
                }
            }
            return;
        }
        if (eventObject instanceof MouseEvent) {
            this.dispatchMouseEvent((MouseEvent)eventObject);
        } else if (eventObject instanceof KeyEvent) {
            InputEvent inputEvent = (InputEvent)eventObject;
            if (this.isNodeIncrementEvent(inputEvent)) {
                this.incrementKeyTarget();
            } else if (this.isNodeDecrementEvent(inputEvent)) {
                this.decrementKeyTarget();
            } else {
                this.dispatchKeyEvent((KeyEvent)eventObject);
            }
        }
    }

    protected void dispatchKeyEvent(KeyEvent keyEvent) {
        this.currentKeyEventTarget = this.lastHit;
        if (this.currentKeyEventTarget != null) {
            this.processKeyEvent(new GraphicsNodeKeyEvent(this.currentKeyEventTarget, keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar()));
        }
    }

    protected void dispatchMouseEvent(MouseEvent mouseEvent) {
        GraphicsNodeMouseEvent graphicsNodeMouseEvent;
        Point point;
        Point2D.Float float_ = new Point2D.Float(mouseEvent.getX(), mouseEvent.getY());
        Point2D point2D = float_;
        if (this.baseTransform != null) {
            point2D = this.baseTransform.transform(float_, null);
        }
        GraphicsNode graphicsNode = this.root.nodeHitAt(point2D);
        if (!mouseEvent.getComponent().isShowing()) {
            point = new Point(0, 0);
        } else {
            point = mouseEvent.getComponent().getLocationOnScreen();
            point.x += mouseEvent.getX();
            point.y += mouseEvent.getY();
        }
        if (this.lastHit != graphicsNode) {
            if (this.lastHit != null) {
                graphicsNodeMouseEvent = new GraphicsNodeMouseEvent(this.lastHit, 505, mouseEvent.getWhen(), mouseEvent.getModifiers(), (float)point2D.getX(), (float)point2D.getY(), (int)Math.floor(((Point2D)float_).getX()), (int)Math.floor(((Point2D)float_).getY()), point.x, point.y, mouseEvent.getClickCount(), graphicsNode);
                this.processMouseEvent(graphicsNodeMouseEvent);
            }
            if (graphicsNode != null) {
                graphicsNodeMouseEvent = new GraphicsNodeMouseEvent(graphicsNode, 504, mouseEvent.getWhen(), mouseEvent.getModifiers(), (float)point2D.getX(), (float)point2D.getY(), (int)Math.floor(((Point2D)float_).getX()), (int)Math.floor(((Point2D)float_).getY()), point.x, point.y, mouseEvent.getClickCount(), this.lastHit);
                this.processMouseEvent(graphicsNodeMouseEvent);
            }
        }
        if (graphicsNode != null) {
            graphicsNodeMouseEvent = new GraphicsNodeMouseEvent(graphicsNode, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), (float)point2D.getX(), (float)point2D.getY(), (int)Math.floor(((Point2D)float_).getX()), (int)Math.floor(((Point2D)float_).getY()), point.x, point.y, mouseEvent.getClickCount(), null);
            this.processMouseEvent(graphicsNodeMouseEvent);
        } else {
            graphicsNodeMouseEvent = new GraphicsNodeMouseEvent(this.root, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), (float)point2D.getX(), (float)point2D.getY(), (int)Math.floor(((Point2D)float_).getX()), (int)Math.floor(((Point2D)float_).getY()), point.x, point.y, mouseEvent.getClickCount(), null);
            this.processMouseEvent(graphicsNodeMouseEvent);
        }
        this.lastHit = graphicsNode;
    }

    protected void processMouseEvent(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
        if (this.glisteners != null) {
            GraphicsNodeMouseListener[] graphicsNodeMouseListenerArray = (GraphicsNodeMouseListener[])this.getListeners(GraphicsNodeMouseListener.class);
            switch (graphicsNodeMouseEvent.getID()) {
                case 503: {
                    for (int i = 0; i < graphicsNodeMouseListenerArray.length; ++i) {
                        graphicsNodeMouseListenerArray[i].mouseMoved(graphicsNodeMouseEvent);
                    }
                    break;
                }
                case 506: {
                    for (int i = 0; i < graphicsNodeMouseListenerArray.length; ++i) {
                        graphicsNodeMouseListenerArray[i].mouseDragged(graphicsNodeMouseEvent);
                    }
                    break;
                }
                case 504: {
                    for (int i = 0; i < graphicsNodeMouseListenerArray.length; ++i) {
                        graphicsNodeMouseListenerArray[i].mouseEntered(graphicsNodeMouseEvent);
                    }
                    break;
                }
                case 505: {
                    for (int i = 0; i < graphicsNodeMouseListenerArray.length; ++i) {
                        graphicsNodeMouseListenerArray[i].mouseExited(graphicsNodeMouseEvent);
                    }
                    break;
                }
                case 500: {
                    for (int i = 0; i < graphicsNodeMouseListenerArray.length; ++i) {
                        graphicsNodeMouseListenerArray[i].mouseClicked(graphicsNodeMouseEvent);
                    }
                    break;
                }
                case 501: {
                    for (int i = 0; i < graphicsNodeMouseListenerArray.length; ++i) {
                        graphicsNodeMouseListenerArray[i].mousePressed(graphicsNodeMouseEvent);
                    }
                    break;
                }
                case 502: {
                    for (int i = 0; i < graphicsNodeMouseListenerArray.length; ++i) {
                        graphicsNodeMouseListenerArray[i].mouseReleased(graphicsNodeMouseEvent);
                    }
                    break;
                }
                default: {
                    throw new Error("Unknown Mouse Event type: " + graphicsNodeMouseEvent.getID());
                }
            }
        }
    }

    public void processKeyEvent(GraphicsNodeKeyEvent graphicsNodeKeyEvent) {
        if (this.glisteners != null) {
            GraphicsNodeKeyListener[] graphicsNodeKeyListenerArray = (GraphicsNodeKeyListener[])this.getListeners(GraphicsNodeKeyListener.class);
            switch (graphicsNodeKeyEvent.getID()) {
                case 401: {
                    for (int i = 0; i < graphicsNodeKeyListenerArray.length; ++i) {
                        graphicsNodeKeyListenerArray[i].keyPressed(graphicsNodeKeyEvent);
                    }
                    break;
                }
                case 402: {
                    for (int i = 0; i < graphicsNodeKeyListenerArray.length; ++i) {
                        graphicsNodeKeyListenerArray[i].keyReleased(graphicsNodeKeyEvent);
                    }
                    break;
                }
                case 400: {
                    for (int i = 0; i < graphicsNodeKeyListenerArray.length; ++i) {
                        graphicsNodeKeyListenerArray[i].keyTyped(graphicsNodeKeyEvent);
                    }
                    break;
                }
                default: {
                    throw new Error("Unknown Key Event type: " + graphicsNodeKeyEvent.getID());
                }
            }
        }
        graphicsNodeKeyEvent.consume();
    }

    private void incrementKeyTarget() {
        throw new Error("Increment not implemented.");
    }

    private void decrementKeyTarget() {
        throw new Error("Decrement not implemented.");
    }

    public void setNodeIncrementEvent(InputEvent inputEvent) {
        this.nodeIncrementEventID = inputEvent.getID();
        if (inputEvent instanceof KeyEvent) {
            this.nodeIncrementEventCode = ((KeyEvent)inputEvent).getKeyCode();
        }
        this.nodeIncrementEventModifiers = inputEvent.getModifiers();
    }

    public void setNodeDecrementEvent(InputEvent inputEvent) {
        this.nodeDecrementEventID = inputEvent.getID();
        if (inputEvent instanceof KeyEvent) {
            this.nodeDecrementEventCode = ((KeyEvent)inputEvent).getKeyCode();
        }
        this.nodeDecrementEventModifiers = inputEvent.getModifiers();
    }

    protected boolean isNodeIncrementEvent(InputEvent inputEvent) {
        return inputEvent.getID() == this.nodeIncrementEventID && (!(inputEvent instanceof KeyEvent) || ((KeyEvent)inputEvent).getKeyCode() == this.nodeIncrementEventCode) && (inputEvent.getModifiers() & this.nodeIncrementEventModifiers) != 0;
    }

    protected boolean isNodeDecrementEvent(InputEvent inputEvent) {
        return inputEvent.getID() == this.nodeDecrementEventID && (!(inputEvent instanceof KeyEvent) || ((KeyEvent)inputEvent).getKeyCode() == this.nodeDecrementEventCode) && (inputEvent.getModifiers() & this.nodeDecrementEventModifiers) != 0;
    }
}

