/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.zip.Adler32;
import java.util.zip.Checksum;
import org.apache.batik.svggen.DOMTreeManager;
import org.apache.batik.svggen.ErrorConstants;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.apache.batik.svggen.SVGSyntax;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class ImageCacher
implements SVGSyntax,
ErrorConstants {
    DOMTreeManager domTreeManager = null;
    Hashtable imageCache = new Hashtable();
    Checksum checkSum = new Adler32();

    public ImageCacher() {
    }

    public ImageCacher(DOMTreeManager dOMTreeManager) {
        this();
        this.setDOMTreeManager(dOMTreeManager);
    }

    public void setDOMTreeManager(DOMTreeManager dOMTreeManager) {
        if (dOMTreeManager == null) {
            throw new IllegalArgumentException();
        }
        this.domTreeManager = dOMTreeManager;
    }

    public DOMTreeManager getDOMTreeManager() {
        return this.domTreeManager;
    }

    public String lookup(ByteArrayOutputStream byteArrayOutputStream, int n, int n2, SVGGeneratorContext sVGGeneratorContext) throws SVGGraphics2DIOException {
        Object object;
        int n3 = this.getChecksum(byteArrayOutputStream.toByteArray());
        Integer n4 = new Integer(n3);
        String string = null;
        Object object2 = this.getCacheableData(byteArrayOutputStream);
        LinkedList<Object> linkedList = (LinkedList<Object>)this.imageCache.get(n4);
        if (linkedList == null) {
            linkedList = new LinkedList<Object>();
            this.imageCache.put(n4, linkedList);
        } else {
            object = linkedList.listIterator(0);
            while (object.hasNext()) {
                ImageCacheEntry imageCacheEntry = (ImageCacheEntry)object.next();
                if (imageCacheEntry.checksum != n3 || !this.imagesMatch(imageCacheEntry.src, object2)) continue;
                string = imageCacheEntry.href;
                break;
            }
        }
        if (string == null) {
            object = this.createEntry(n3, object2, n, n2, sVGGeneratorContext);
            linkedList.add(object);
            string = ((ImageCacheEntry)object).href;
        }
        return string;
    }

    abstract Object getCacheableData(ByteArrayOutputStream var1);

    abstract boolean imagesMatch(Object var1, Object var2) throws SVGGraphics2DIOException;

    abstract ImageCacheEntry createEntry(int var1, Object var2, int var3, int var4, SVGGeneratorContext var5) throws SVGGraphics2DIOException;

    int getChecksum(byte[] byArray) {
        this.checkSum.reset();
        this.checkSum.update(byArray, 0, byArray.length);
        return (int)this.checkSum.getValue();
    }

    public static class External
    extends ImageCacher {
        private String imageDir;
        private String prefix;
        private String suffix;

        public External(String string, String string2, String string3) {
            this.imageDir = string;
            this.prefix = string2;
            this.suffix = string3;
        }

        Object getCacheableData(ByteArrayOutputStream byteArrayOutputStream) {
            return byteArrayOutputStream;
        }

        boolean imagesMatch(Object object, Object object2) throws SVGGraphics2DIOException {
            boolean bl = false;
            try {
                FileInputStream fileInputStream = new FileInputStream((File)object);
                int n = fileInputStream.available();
                byte[] byArray = new byte[n];
                byte[] byArray2 = ((ByteArrayOutputStream)object2).toByteArray();
                for (int i = 0; i != n; i += fileInputStream.read(byArray, i, n - i)) {
                }
                bl = Arrays.equals(byArray, byArray2);
            }
            catch (IOException iOException) {
                throw new SVGGraphics2DIOException("could not read image File " + ((File)object).getName());
            }
            return bl;
        }

        ImageCacheEntry createEntry(int n, Object object, int n2, int n3, SVGGeneratorContext sVGGeneratorContext) throws SVGGraphics2DIOException {
            File file = null;
            try {
                Object object2;
                while (file == null) {
                    object2 = sVGGeneratorContext.idGenerator.generateID(this.prefix);
                    file = new File(this.imageDir, (String)object2 + this.suffix);
                    if (!file.exists()) continue;
                    file = null;
                }
                object2 = new FileOutputStream(file);
                ((ByteArrayOutputStream)object).writeTo((OutputStream)object2);
                ((ByteArrayOutputStream)object).close();
            }
            catch (IOException iOException) {
                throw new SVGGraphics2DIOException("could not write image File " + file.getName());
            }
            return new ImageCacheEntry(n, file, file.getName());
        }
    }

    public static class Embedded
    extends ImageCacher {
        public void setDOMTreeManager(DOMTreeManager dOMTreeManager) {
            if (this.domTreeManager != dOMTreeManager) {
                this.domTreeManager = dOMTreeManager;
                this.imageCache = new Hashtable();
            }
        }

        Object getCacheableData(ByteArrayOutputStream byteArrayOutputStream) {
            return "data:image/png;base64," + byteArrayOutputStream.toString();
        }

        boolean imagesMatch(Object object, Object object2) {
            return object.equals(object2);
        }

        ImageCacheEntry createEntry(int n, Object object, int n2, int n3, SVGGeneratorContext sVGGeneratorContext) {
            String string = sVGGeneratorContext.idGenerator.generateID("image");
            this.addToTree(string, (String)object, n2, n3, sVGGeneratorContext);
            return new ImageCacheEntry(n, object, "#" + string);
        }

        private void addToTree(String string, String string2, int n, int n2, SVGGeneratorContext sVGGeneratorContext) {
            Document document = this.domTreeManager.getDOMFactory();
            Element element = document.createElementNS("http://www.w3.org/2000/svg", "image");
            element.setAttributeNS(null, "id", string);
            element.setAttributeNS(null, "width", Integer.toString(n));
            element.setAttributeNS(null, "height", Integer.toString(n2));
            element.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", string2);
            this.domTreeManager.addOtherDef(element);
        }
    }

    private static class ImageCacheEntry {
        public int checksum;
        public Object src;
        public String href;

        public ImageCacheEntry(int n, Object object, String string) {
            this.checksum = n;
            this.src = object;
            this.href = string;
        }
    }
}

