/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server;

import com.vmware.vim.binding.vmodl.DataObject;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.fault.SecurityError;
import com.vmware.vim.vmomi.core.types.ComplexTypeField;
import com.vmware.vim.vmomi.core.types.DataObjectType;
import com.vmware.vim.vmomi.core.types.ManagedMethod;
import com.vmware.vim.vmomi.core.types.VmodlArrayType;
import com.vmware.vim.vmomi.core.types.VmodlField;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.server.Activation;
import com.vmware.vim.vmomi.server.ActivationValidator;
import com.vmware.vim.vmomi.server.Authorizer;
import com.vmware.vim.vmomi.server.PrivilegeAuthorizer;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public class PrivilegeChecker
implements ActivationValidator {
    private Authorizer _authorizer;
    private PrivilegeAuthorizer _objAuthorizer;

    @Deprecated
    public PrivilegeChecker(Authorizer authorizer) {
        this._authorizer = authorizer;
    }

    public PrivilegeChecker(PrivilegeAuthorizer objAuthorizer) {
        this._objAuthorizer = objAuthorizer;
    }

    @Override
    public void validate(Activation activation, ActivationValidator.Future future) {
        AuthorizerFuture authFuture = new AuthorizerFuture(future);
        if (this._authorizer != null) {
            this._authorizer.authorize(activation, PrivilegeChecker.collectRequiredMoRefPrivileges(activation), authFuture);
        } else {
            this._objAuthorizer.authorize(activation, PrivilegeChecker.collectRequiredPrivileges(activation), authFuture);
        }
    }

    static List<Authorizer.ObjectPrivilege> collectRequiredPrivileges(Activation activation) {
        ArrayList<Authorizer.ObjectPrivilege> requiredPrivileges = new ArrayList<Authorizer.ObjectPrivilege>();
        ManagedMethod method = activation.getMethod();
        PrivilegeChecker.addMethodPrivileges(method, activation.getTarget(), requiredPrivileges);
        PrivilegeChecker.addParameterPrivileges(method, activation.getArgs(), requiredPrivileges);
        return requiredPrivileges;
    }

    static List<Authorizer.MoRefPrivilege> collectRequiredMoRefPrivileges(Activation activation) {
        List<Authorizer.ObjectPrivilege> requiredPrivileges = PrivilegeChecker.collectRequiredPrivileges(activation);
        ArrayList<Authorizer.MoRefPrivilege> requiredMoRefPrivileges = new ArrayList<Authorizer.MoRefPrivilege>();
        for (Authorizer.ObjectPrivilege objPrivilege : requiredPrivileges) {
            if (!(objPrivilege instanceof Authorizer.MoRefPrivilege)) continue;
            requiredMoRefPrivileges.add((Authorizer.MoRefPrivilege)objPrivilege);
        }
        return requiredMoRefPrivileges;
    }

    static void addMethodPrivileges(ManagedMethod method, ManagedObject targetMo, List<Authorizer.ObjectPrivilege> privileges) {
        String methodPrivilege = method.getPrivilegeId();
        if (methodPrivilege == null || "dynamic".equals(methodPrivilege)) {
            methodPrivilege = "System.Read";
        }
        privileges.add(new Authorizer.MoRefPrivilege(targetMo._getRef(), methodPrivilege));
    }

    static void addParameterPrivileges(ManagedMethod method, Object[] args, List<Authorizer.ObjectPrivilege> privileges) {
        VmodlField[] parameters = method.getParameters();
        block6: for (int i = 0; i < parameters.length; ++i) {
            VmodlField parameter = parameters[i];
            if (args[i] == null) continue;
            String paramPrivilege = parameter.GetPrivilegeId();
            if (paramPrivilege == null) {
                paramPrivilege = "System.Read";
            }
            switch (parameter.getType().getKind()) {
                case ARRAY: {
                    VmodlArrayType arrayType = (VmodlArrayType)parameter.getType();
                    PrivilegeChecker.addArrayPrivileges(arrayType.getComponentType(), args[i], paramPrivilege, privileges);
                    continue block6;
                }
                case MOREF: {
                    ManagedObjectReference moRef = (ManagedObjectReference)args[i];
                    privileges.add(new Authorizer.MoRefPrivilege(moRef, paramPrivilege));
                    continue block6;
                }
                case DATA_OBJECT: {
                    PrivilegeChecker.addDataObjectReadPrivileges((DataObject)args[i], (DataObjectType)parameter.getType(), privileges);
                    continue block6;
                }
                case URI: {
                    privileges.add(new Authorizer.UriPrivilege((URI)args[i], paramPrivilege));
                }
            }
        }
    }

    static void addDataObjectReadPrivileges(DataObject dataObject, DataObjectType dataObjectType, List<Authorizer.ObjectPrivilege> privileges) {
        ComplexTypeField[] properties;
        for (ComplexTypeField property : properties = dataObjectType.getProperties()) {
            VmodlType.Kind kind;
            Object value;
            if (property.isLink() || (value = property.get((Object)dataObject)) == null) continue;
            String privilege = property.GetPrivilegeId();
            if (privilege == null) {
                privilege = "System.Read";
            }
            if ((kind = property.getType().getKind()) == VmodlType.Kind.MOREF) {
                privileges.add(new Authorizer.MoRefPrivilege((ManagedObjectReference)value, privilege));
                continue;
            }
            if (kind == VmodlType.Kind.DATA_OBJECT) {
                PrivilegeChecker.addDataObjectReadPrivileges((DataObject)value, (DataObjectType)property.getType(), privileges);
                continue;
            }
            if (kind == VmodlType.Kind.ARRAY) {
                VmodlArrayType arrayType = (VmodlArrayType)property.getType();
                PrivilegeChecker.addArrayPrivileges(arrayType.getComponentType(), value, privilege, privileges);
                continue;
            }
            if (kind != VmodlType.Kind.URI) continue;
            privileges.add(new Authorizer.UriPrivilege((URI)value, privilege));
        }
    }

    static void addArrayPrivileges(VmodlType itemType, Object value, String privId, List<Authorizer.ObjectPrivilege> privileges) {
        block4: {
            URI[] uris;
            block5: {
                DataObject[] dataObjects;
                block3: {
                    ManagedObjectReference[] moRefs;
                    if (itemType.getKind() != VmodlType.Kind.MOREF) break block3;
                    for (ManagedObjectReference moRef : moRefs = (ManagedObjectReference[])value) {
                        privileges.add(new Authorizer.MoRefPrivilege(moRef, privId));
                    }
                    break block4;
                }
                if (itemType.getKind() != VmodlType.Kind.DATA_OBJECT) break block5;
                for (DataObject dataObject : dataObjects = (DataObject[])value) {
                    PrivilegeChecker.addDataObjectReadPrivileges(dataObject, (DataObjectType)itemType, privileges);
                }
                break block4;
            }
            if (itemType.getKind() != VmodlType.Kind.URI) break block4;
            for (URI uri : uris = (URI[])value) {
                privileges.add(new Authorizer.UriPrivilege(uri, privId));
            }
        }
    }

    static class AuthorizerFuture
    implements Authorizer.Future {
        private ActivationValidator.Future _future;

        AuthorizerFuture(ActivationValidator.Future future) {
            this._future = future;
        }

        @Override
        public void setAuthorized() {
            this._future.setValid();
        }

        @Override
        public void setSecurityError(SecurityError error) {
            this._future.setFault((Exception)error);
        }

        @Override
        public boolean isAuthorized() {
            return this._future.isValid();
        }

        @Override
        public SecurityError getSecurityError() {
            return (SecurityError)this._future.getFault();
        }
    }

    public static class Privilege {
        public static final String DYNAMIC = "dynamic";
        public static final String SYSTEM_READ = "System.Read";
        public static final String SYSTEM_VIEW = "System.View";
        public static final String SYSTEM_ANON = "System.Anonymous";
        public static final String SYSTEM_GROUP = "System";
    }
}

