/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.common.impl;

import com.vmware.vim.binding.vmodl.fault.SystemError;
import com.vmware.vim.vmomi.core.common.LifecycleListener;
import com.vmware.vim.vmomi.server.Activation;
import com.vmware.vim.vmomi.server.common.ChainedProcessingStep;
import com.vmware.vim.vmomi.server.common.ProcessingStep;
import com.vmware.vim.vmomi.server.common.RejectionHandler;
import com.vmware.vim.vmomi.server.common.ThreadConfigurator;
import com.vmware.vim.vmomi.server.common.impl.BaseRejectionHandler;
import com.vmware.vim.vmomi.server.common.impl.RunnableWrapper;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseProcessingStep<InType, OutType>
implements ChainedProcessingStep<InType, OutType>,
LifecycleListener {
    private static int DEFAULT_SHUTDOWN_TIMEOUT = 3;
    private ProcessingStep<OutType> _nextStep;
    private ExecutorService _exe;
    private RejectionHandler _rejectionHandler;
    private long _timeOut = DEFAULT_SHUTDOWN_TIMEOUT;
    private ThreadConfigurator _threadConfigurator;
    private static final Log _logger = LogFactory.getLog(BaseProcessingStep.class);

    @Override
    public ProcessingStep<OutType> getNextStep() {
        return this._nextStep;
    }

    public void setNextStep(ProcessingStep<OutType> nextStep) {
        this._nextStep = nextStep;
    }

    public void setExecutor(ExecutorService exe) {
        this._exe = exe;
    }

    public void setRejectionHandler(BaseRejectionHandler handler) {
        this._rejectionHandler = handler;
    }

    public void setShutdownTimeout(long timeOut) {
        this._timeOut = timeOut;
    }

    @Override
    public void process(InType item) {
        try {
            this._exe.execute(this.wrap(this.buildTask(item)));
        }
        catch (RejectedExecutionException ex) {
            if (_logger.isErrorEnabled()) {
                _logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
            this.handleRejectedExecution(ex, item);
        }
    }

    public void shutdown() {
        this._exe.shutdown();
        try {
            if (this._exe.awaitTermination(this._timeOut, TimeUnit.SECONDS)) {
                return;
            }
            if (_logger.isWarnEnabled()) {
                _logger.warn((Object)("Could not gracefully shutdown executor service at step  " + this + ", forcing shutdown..."));
            }
            this.shutdownNow();
            if (!this._exe.awaitTermination(this._timeOut, TimeUnit.SECONDS) && _logger.isWarnEnabled()) {
                _logger.warn((Object)("Could not shutdown the executor service at step " + this));
            }
        }
        catch (InterruptedException ie) {
            this._exe.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public void shutdownNow() {
        this._exe.shutdownNow();
    }

    void handleRejectedExecution(RejectedExecutionException ex, InType item) {
        if (this._rejectionHandler == null) {
            throw ex;
        }
        SystemError fault = this.buildSystemError(ex);
        this._rejectionHandler.handleRejectedItem(this.buildErrorActivation(item, (Exception)fault), item);
    }

    private SystemError buildSystemError(RejectedExecutionException ex) {
        SystemError fault = new SystemError();
        fault.setMessage("Executor rejected to handle task at step " + this);
        fault.setReason(ex.getMessage());
        fault.initCause((Throwable)ex);
        return fault;
    }

    public void setThreadConfigurator(ThreadConfigurator configurator) {
        this._threadConfigurator = configurator;
    }

    private Runnable wrap(Runnable r) {
        if (this._threadConfigurator == null) {
            return r;
        }
        return RunnableWrapper.wrap(r, this._threadConfigurator);
    }

    public abstract Runnable buildTask(InType var1);

    public abstract Activation buildErrorActivation(InType var1, Exception var2);
}

