/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.http.impl;

import com.vmware.vim.binding.vmodl.RuntimeFault;
import com.vmware.vim.vmomi.core.exception.MarshallException;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.server.Activation;
import com.vmware.vim.vmomi.server.common.DiagnosticContextProvider;
import com.vmware.vim.vmomi.server.exception.ExceptionUtil;
import com.vmware.vim.vmomi.server.http.Responder;
import com.vmware.vim.vmomi.server.impl.Correlator;
import com.vmware.vim.vmomi.server.impl.SoapBindingImpl;
import com.vmware.vim.vmomi.server.impl.SoapReply;
import com.vmware.vim.vmomi.server.util.DiagnosticContextUtils;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompletionContinuerTask
implements Runnable,
DiagnosticContextProvider {
    private static final Log _logger = LogFactory.getLog(CompletionContinuerTask.class);
    private VmodlContext _vmodlContext;
    private Activation _activation;
    private Correlator<?> _correlator;
    private Responder _responder;

    public CompletionContinuerTask(Activation activation, VmodlContext vmodlContext, Correlator<?> correlator, Responder responder) {
        this._activation = activation;
        this._vmodlContext = vmodlContext;
        this._correlator = correlator;
        this._responder = responder;
    }

    @Override
    public void run() {
        this.complete();
        this._responder.returnResponse(this._activation.getResponse(), this._correlator);
    }

    public void complete() {
        block3: {
            try {
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)"Completing activation");
                }
                this.complete(this._activation);
            }
            catch (Exception ex) {
                if (!_logger.isErrorEnabled()) break block3;
                _logger.error((Object)"Internal server error during response marshalling", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void complete(Activation activation) throws XMLStreamException, MarshallException {
        try {
            SoapBindingImpl binding = new SoapBindingImpl(activation.getVersion(), this._vmodlContext);
            Exception fault = activation.getFault();
            try {
                SoapReply reply = new SoapReply(binding, activation.getResponse().getResponseContext());
                if (fault == null) {
                    binding.serializeResponse(reply.getWriter(), activation.getMethod(), activation.getReturnValue());
                } else {
                    binding.serializeFault(reply.getWriter(), activation.getMethod(), fault);
                    activation.getResponse().setFault(true);
                }
                this.finishSoapReply(activation, reply);
            }
            catch (Exception e) {
                RuntimeFault newFault = ExceptionUtil.buildFaultForInternalException(e, "Failed to serialize response");
                if (_logger.isErrorEnabled()) {
                    _logger.error((Object)newFault.getMessage(), (Throwable)newFault);
                }
                SoapReply reply = new SoapReply(binding, activation.getResponse().getResponseContext());
                binding.serializeFault(reply.getWriter(), activation.getMethod(), (Exception)newFault);
                activation.getResponse().setFault(true);
                this.finishSoapReply(activation, reply);
            }
        }
        finally {
            activation.getSession().returnSession();
        }
    }

    protected void finishSoapReply(Activation activation, SoapReply reply) throws XMLStreamException {
        reply.finish();
        activation.getResponse().setResponseBody(reply.toString());
    }

    @Override
    public Map<String, Object> getDiagnosticContext() {
        return DiagnosticContextUtils.getDiagnosticContext(this._activation.getRequest().getRequestContext());
    }
}

