/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.http.impl;

import com.vmware.vim.vmomi.server.Activation;
import com.vmware.vim.vmomi.server.Dispatcher;
import com.vmware.vim.vmomi.server.common.ChainedProcessingStep;
import com.vmware.vim.vmomi.server.common.Request;
import com.vmware.vim.vmomi.server.http.impl.CorrelationTask;
import com.vmware.vim.vmomi.server.http.impl.RequestImpl;
import com.vmware.vim.vmomi.server.impl.Correlator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CorrelationDispatcherTask
implements Runnable {
    private static final Log _logger = LogFactory.getLog(CorrelationTask.class);
    private Correlator<Object> _correlator;
    private Request _request;
    private Dispatcher _dispatcher;
    private ChainedProcessingStep<Activation, Activation> _nextStep;
    private ChainedProcessingStep<Activation, Activation> _completionStep;

    public CorrelationDispatcherTask(Correlator<Object> correlator, Request request, Dispatcher dispatcher, ChainedProcessingStep<Activation, Activation> nextStep, ChainedProcessingStep<Activation, Activation> completionStep) {
        this._correlator = correlator;
        this._request = request;
        this._dispatcher = dispatcher;
        this._nextStep = nextStep;
        this._completionStep = completionStep;
    }

    @Override
    public void run() {
        block3: {
            try {
                RequestImpl request = (RequestImpl)this._request;
                String correlatorId = request.getCorrelator();
                Object requestObj = request.getObject();
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("Associating " + requestObj + " to correlation ID: " + correlatorId));
                }
                this._correlator.put(correlatorId, requestObj);
                this._dispatcher.dispatch(this._request, this._nextStep, this._completionStep);
            }
            catch (RuntimeException ex) {
                if (!_logger.isErrorEnabled()) break block3;
                _logger.error((Object)"Internal server error during request correlation", (Throwable)ex);
            }
        }
    }
}

