/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.http.impl;

import com.vmware.vim.vmomi.server.http.Endpoint;
import com.vmware.vim.vmomi.server.http.SslEndpoint;
import com.vmware.vim.vmomi.server.http.impl.HttpEndpoint;
import java.io.IOException;
import org.springframework.core.io.Resource;

public class HttpsEndpoint
extends HttpEndpoint
implements SslEndpoint {
    private String _keyStorePath;
    private String _keyStorePassword;
    private String _keyPassword;
    private String _keyStoreType;
    private String _trustStorePath;
    private String _trustStorePassword;
    private boolean _needClientAuth;
    private boolean _wantClientAuth;
    private boolean _trustAllClients;
    private String _enabledProtocols;

    public HttpsEndpoint(String host, int port) {
        super(host, port, Endpoint.Protocol.HTTPS);
        this._host = host;
        this._port = port;
        this._needClientAuth = false;
        this._wantClientAuth = false;
        this._trustAllClients = false;
    }

    public HttpsEndpoint(int port) {
        this("0.0.0.0", port);
    }

    public void setKeyStoreType(String type) {
        this._keyStoreType = type;
    }

    public void setKeyStorePath(String keyStorePath) {
        this._keyStorePath = keyStorePath;
    }

    public void setKeyStoreResource(Resource keystore) throws IOException {
        this._keyStorePath = keystore.getFile().getAbsolutePath();
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this._keyStorePassword = keyStorePassword;
    }

    public void setKeyPassword(String keyPassword) {
        this._keyPassword = keyPassword;
    }

    public void setTrustStorePath(String trustStorePath) {
        this._trustStorePath = trustStorePath;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this._trustStorePassword = trustStorePassword;
    }

    @Override
    public String getKeyStorePath() {
        return this._keyStorePath;
    }

    @Override
    public String getKeyStorePassword() {
        return this._keyStorePassword;
    }

    @Override
    public String getKeyPassword() {
        return this._keyPassword;
    }

    @Override
    public String getKeyAlias() {
        return "jetty";
    }

    @Override
    public String getTrustStorePath() {
        return this._trustStorePath;
    }

    @Override
    public String getTrustStorePassword() {
        return this._trustStorePassword;
    }

    @Override
    public void setNeedClientAuth(boolean needed) {
        this._needClientAuth = needed;
    }

    @Override
    public boolean getNeedClientAuth() {
        return this._needClientAuth;
    }

    @Override
    public boolean getWantClientAuth() {
        return this._wantClientAuth;
    }

    @Override
    public void setWantClientAuth(boolean wanted) {
        this._wantClientAuth = wanted;
    }

    @Override
    public void setTrustAllClients(boolean trustAllClients) {
        this._trustAllClients = trustAllClients;
    }

    @Override
    public boolean getTrustAllClients() {
        return this._trustAllClients;
    }

    @Override
    public String getKeyStoreType() {
        return this._keyStoreType;
    }

    @Override
    public void setEnabledProtocols(String enabledProtocols) {
        this._enabledProtocols = enabledProtocols;
    }

    @Override
    public String getEnabledProtocols() {
        return this._enabledProtocols;
    }
}

