/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.http.impl;

import com.vmware.vim.vmomi.server.http.Server;
import com.vmware.vim.vmomi.server.http.ServerConfigurator;
import com.vmware.vim.vmomi.server.http.impl.JettyServer;
import javax.servlet.ServletContext;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.servlet.Context;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.StringUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class JettySpringServerConfigurator
implements ServerConfigurator,
ApplicationContextAware {
    private ApplicationContext _applicationContext;
    private String _configLocation;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this._applicationContext = applicationContext;
    }

    public void setConfigLocation(String configLocation) {
        this._configLocation = configLocation;
    }

    @Override
    public void configure(Server server) {
        Context context = ((JettyServer)server).getContext();
        ContextHandler.SContext servletContext = context.getServletContext();
        XmlWebApplicationContext wctx = new XmlWebApplicationContext();
        wctx.setParent(this._applicationContext);
        if (StringUtils.hasLength((String)this._configLocation)) {
            wctx.setConfigLocation(this._configLocation);
        } else {
            wctx.setConfigLocation("");
        }
        wctx.setServletContext((ServletContext)servletContext);
        wctx.refresh();
        servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)wctx);
    }
}

