/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.http.impl;

import com.vmware.vim.vmomi.server.common.Response;
import com.vmware.vim.vmomi.server.common.impl.SslBindingInfoImpl;
import com.vmware.vim.vmomi.server.http.impl.RequestImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.cert.X509Certificate;
import java.util.concurrent.RejectedExecutionException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmomiServletUtils {
    private static final long serialVersionUID = 1L;
    private static final String UTF_8 = "UTF-8";
    private static Log _logger = LogFactory.getLog(VmomiServletUtils.class);

    static void getSessionCookie(HttpServletRequest servletRequest, RequestImpl request) {
        Cookie[] cookies = servletRequest.getCookies();
        if (cookies == null) {
            return;
        }
        for (Cookie cookie : cookies) {
            if (!"vmware_soap_session".equals(cookie.getName())) continue;
            request.setSessionCookie(cookie.getValue());
            String path = cookie.getPath();
            if (path == null) break;
            request.setSessionCookiePath(path);
            break;
        }
    }

    private static void checkMaxLength(int len, int maxLen) throws ServletException {
        if (len > maxLen) {
            throw new ServletException("Content length above the limit");
        }
    }

    public static RequestImpl parseRequest(HttpServletRequest servletRequest, int maxLen) throws ServletException, IOException {
        int numRead;
        int len = servletRequest.getContentLength();
        if (len < 0) {
            len = 8192;
        }
        VmomiServletUtils.checkMaxLength(len, maxLen);
        String charset = servletRequest.getCharacterEncoding();
        if (charset == null) {
            servletRequest.setCharacterEncoding(UTF_8);
            charset = UTF_8;
        }
        StringBuilder stringBuilder = new StringBuilder(len);
        Reader reader = null;
        if ("gzip".equals(servletRequest.getHeader("Content-Encoding"))) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)"Received HTTP request with gzip content encoding.");
            }
            reader = new InputStreamReader((InputStream)new GZIPInputStream((InputStream)servletRequest.getInputStream()), charset);
        } else {
            reader = servletRequest.getReader();
        }
        char[] buffer = new char[len];
        while ((numRead = ((Reader)reader).read(buffer, 0, len)) >= 0) {
            VmomiServletUtils.checkMaxLength(stringBuilder.length() + numRead, maxLen);
            stringBuilder.append(buffer, 0, numRead);
        }
        RequestImpl request = new RequestImpl();
        request.setRequestBody(stringBuilder);
        request.setContentType(servletRequest.getHeader("Content-Type"));
        String soapAction = servletRequest.getHeader("SOAPAction");
        if (soapAction != null) {
            soapAction = soapAction.replaceAll("\"", "");
        }
        request.setSoapAction(soapAction);
        request.setRequestUri(servletRequest.getRequestURI());
        VmomiServletUtils.getSessionCookie(servletRequest, request);
        X509Certificate[] certs = (X509Certificate[])servletRequest.getAttribute("javax.servlet.request.X509Certificate");
        SslBindingInfoImpl sslBindingInfo = new SslBindingInfoImpl(certs);
        sslBindingInfo.setPeerAddress(servletRequest.getRemoteAddr());
        sslBindingInfo.setPeerPort(servletRequest.getRemotePort());
        sslBindingInfo.setAddress(servletRequest.getLocalAddr());
        sslBindingInfo.setPort(servletRequest.getLocalPort());
        request.setBindingInfo(sslBindingInfo);
        return request;
    }

    public static void sendResponse(Response response, String configuredCookiePath, HttpServletRequest servletRequest, HttpServletResponse servletResponse, boolean is30Servlet) throws IOException {
        VmomiServletUtils.prepareResponse(response, configuredCookiePath, servletRequest, servletResponse, is30Servlet);
        if ("gzip".equals(servletRequest.getHeader("Accept-Encoding"))) {
            VmomiServletUtils.writeGzipResponse(response, servletResponse);
        } else {
            servletResponse.getWriter().print(((Object)response.getResponseBody()).toString());
        }
    }

    static void sendResponseFromJetty(Response response, String configuredCookiePath, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        VmomiServletUtils.prepareResponse(response, configuredCookiePath, servletRequest, servletResponse, false);
        if ("gzip".equals(servletRequest.getHeader("Accept-Encoding"))) {
            VmomiServletUtils.writeGzipResponse(response, servletResponse);
        } else {
            ServletOutputStream out = servletResponse.getOutputStream();
            out.write(((Object)response.getResponseBody()).toString().getBytes(UTF_8));
        }
    }

    private static void prepareResponse(Response response, String configuredCookiePath, HttpServletRequest servletRequest, HttpServletResponse servletResponse, boolean is30Servlet) {
        if (_logger.isDebugEnabled() && Boolean.getBoolean("vlsi.debug.server.logResponses")) {
            _logger.debug((Object)String.format("Response body:\n%1$s", response.getResponseBody()));
        }
        servletResponse.setStatus(response.isFault() ? 500 : 200);
        String sessionId = response.getSessionCookie();
        if (sessionId != null) {
            Cookie cookie = new Cookie("vmware_soap_session", sessionId);
            String responseCookiePath = response.getSessionCookiePath();
            if (responseCookiePath != null) {
                cookie.setPath(responseCookiePath);
            } else {
                cookie.setPath(configuredCookiePath);
            }
            cookie.setSecure(servletRequest.isSecure());
            if (is30Servlet) {
                cookie.setHttpOnly(true);
            }
            servletResponse.addCookie(cookie);
        }
        servletResponse.setContentType("text/xml; charset=utf-8");
    }

    private static void writeGzipResponse(Response response, HttpServletResponse servletResponse) throws IOException {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)"Sending HTTP response with gzip content encoding.");
        }
        ServletOutputStream out = servletResponse.getOutputStream();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        GZIPOutputStream os = new GZIPOutputStream(buffer);
        os.write(((Object)response.getResponseBody()).toString().getBytes(UTF_8));
        os.close();
        servletResponse.addHeader("Content-Encoding", "gzip");
        servletResponse.setContentLength(buffer.size());
        out.write(buffer.toByteArray());
    }

    public static void doOptions(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setHeader("Accept-Encoding", "gzip");
    }

    public static void handleRejectedExecution(RejectedExecutionException ex, RequestImpl request, String configuredCookiePath, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        Object response = request.getObject();
        if (response == null || !(response instanceof Response)) {
            throw ex;
        }
        VmomiServletUtils.sendResponse((Response)response, configuredCookiePath, servletRequest, servletResponse, false);
    }
}

