/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.impl;

import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.types.ManagedMethod;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import com.vmware.vim.vmomi.server.Activation;
import com.vmware.vim.vmomi.server.common.Request;
import com.vmware.vim.vmomi.server.common.Response;
import com.vmware.vim.vmomi.server.exception.InvalidSignatureException;
import com.vmware.vim.vmomi.server.exception.SignatureValidationException;
import com.vmware.vim.vmomi.server.security.RequestSignatureValidator;
import com.vmware.vim.vmomi.server.session.Session;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ActivationImpl
implements Activation {
    private VmodlVersion _version;
    private ManagedObject _target;
    private ManagedMethod _method;
    private Object[] _args;
    private Session _session;
    private Request _request;
    private Response _response;
    private Object _returnValue;
    private Exception _fault;
    private List<X509Certificate> _stsCertificates;
    private RequestSignatureValidator _requestSignatureValidator;
    private Map<String, Object> _options = new HashMap<String, Object>();

    public ActivationImpl(VmodlVersion version, ManagedObject target, ManagedMethod method, Object[] args, Session session, Request request, Response response, List<X509Certificate> stsCertificates, RequestSignatureValidator requestSignatureValidator) {
        this._version = version;
        this._target = target;
        this._method = method;
        this._args = new Object[args.length + 1];
        System.arraycopy(args, 0, this._args, 0, args.length);
        this._session = session;
        this._request = request;
        this._response = response;
        this._stsCertificates = stsCertificates;
        this._requestSignatureValidator = requestSignatureValidator == null ? RequestSignatureValidator.DefaultFactory.getInstance() : requestSignatureValidator;
    }

    @Override
    public VmodlVersion getVersion() {
        return this._version;
    }

    @Override
    public ManagedObject getTarget() {
        return this._target;
    }

    @Override
    public ManagedMethod getMethod() {
        return this._method;
    }

    @Override
    public Object[] getArgs() {
        return this._args;
    }

    @Override
    public Session getSession() {
        return this._session;
    }

    @Override
    public Request getRequest() {
        return this._request;
    }

    @Override
    public Response getResponse() {
        return this._response;
    }

    @Override
    public Object getReturnValue() {
        return this._returnValue;
    }

    @Override
    public Exception getFault() {
        return this._fault;
    }

    @Override
    public Future<?> getFutureArg() {
        return (Future)this._args[this._args.length - 1];
    }

    @Override
    public void setFault(Exception fault) {
        this._fault = fault;
    }

    @Override
    public void setReturnValue(Object returnValue) {
        this._returnValue = returnValue;
    }

    @Override
    public void setFutureArg(Future<?> future) {
        this._args[this._args.length - 1] = future;
    }

    @Override
    public SamlToken findSamlToken(List<X509Certificate> stsCertificates) throws InvalidSignatureException, SignatureValidationException {
        if (stsCertificates == null) {
            throw new IllegalStateException("Required STS certificates not set.");
        }
        return this._requestSignatureValidator.validateMessage(this._request.getRequestBody(), stsCertificates);
    }

    @Override
    public SamlToken findSamlToken() throws InvalidSignatureException, SignatureValidationException {
        return this.findSamlToken(this._stsCertificates);
    }

    @Override
    public List<X509Certificate> getSTSCertificates() {
        return this._stsCertificates;
    }

    @Override
    public synchronized void putActivationObject(String key, Object object) {
        this._options.put(key, object);
    }

    @Override
    public synchronized Object getActivationObject(String key) {
        return this._options.get(key);
    }
}

