/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.impl;

import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.util.ServiceObjectUtil;
import com.vmware.vim.vmomi.server.Activation;
import com.vmware.vim.vmomi.server.ActivationResponseFilter;
import com.vmware.vim.vmomi.server.ActivationValidator;
import com.vmware.vim.vmomi.server.AdapterServer;
import com.vmware.vim.vmomi.server.common.ChainedProcessingStep;
import com.vmware.vim.vmomi.server.common.ProcessingStep;
import com.vmware.vim.vmomi.server.exception.ExceptionUtil;
import com.vmware.vim.vmomi.server.impl.ActivationQueueCompletion;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AdapterServerImpl
implements AdapterServer {
    private final Log _logger;
    private final HashMap<String, ManagedObject> _moRegistry;
    private final List<ActivationValidator> _activationValidators;
    private final List<ActivationResponseFilter> _activationResponseFilters;
    private volatile String _guid;
    private volatile List<X509Certificate> _stsCertificates;
    private final VmodlContext _context;

    public AdapterServerImpl() {
        this(VmodlContext.getContext());
    }

    public AdapterServerImpl(VmodlContext context) {
        if (context == null) {
            throw new IllegalArgumentException("VmodlContext parameter is required but null was passsed.");
        }
        this._logger = LogFactory.getLog(this.getClass());
        this._moRegistry = new HashMap();
        this._activationValidators = new ArrayList<ActivationValidator>();
        this._activationResponseFilters = new ArrayList<ActivationResponseFilter>();
        this._context = context;
    }

    @Override
    public void invoke(Activation activation, ChainedProcessingStep<Activation, Activation> validationStep, ChainedProcessingStep<Activation, Activation> filterStep) {
        ProcessingStep<Object> postInvocationStep = this._activationResponseFilters.size() == 0 ? filterStep.getNextStep() : filterStep;
        activation.setFutureArg(new ActivationQueueCompletion(activation, postInvocationStep));
        if (this._activationValidators.size() == 0) {
            validationStep.getNextStep().process(activation);
        } else {
            try {
                validationStep.process(activation);
            }
            catch (Exception e) {
                if (this._logger.isErrorEnabled()) {
                    this._logger.error((Object)"Failed to start activation validation", (Throwable)e);
                }
                activation.getFutureArg().setException((Exception)ExceptionUtil.buildFaultForInternalException(e));
            }
        }
    }

    @Override
    public synchronized void registerManagedObject(ManagedObject mo) {
        mo = ServiceObjectUtil.adaptService((ManagedObject)mo);
        this._moRegistry.put(mo._getRef().getValue(), mo);
    }

    @Override
    public synchronized boolean unregisterManagedObject(ManagedObject mo) {
        ManagedObject obj = this._moRegistry.remove(mo._getRef().getValue());
        return obj != null;
    }

    @Override
    public synchronized ManagedObject lookupManagedObject(String moId) {
        return this._moRegistry.get(moId);
    }

    @Override
    public synchronized void addActivationValidator(ActivationValidator validator) {
        this._activationValidators.add(validator);
    }

    @Override
    public synchronized void addActivationResponseFilter(ActivationResponseFilter filter) {
        this._activationResponseFilters.add(filter);
    }

    public synchronized void setManagedObjects(List<ManagedObject> mos) {
        for (ManagedObject mo : mos) {
            this.registerManagedObject(mo);
        }
    }

    @Override
    public synchronized void setActivationValidators(List<ActivationValidator> validators) {
        this._activationValidators.clear();
        for (ActivationValidator validator : validators) {
            this.addActivationValidator(validator);
        }
    }

    @Override
    public List<ActivationValidator> getActivationValidators() {
        return this._activationValidators;
    }

    @Override
    public synchronized void setActivationResponseFilters(List<ActivationResponseFilter> filters) {
        this._activationResponseFilters.clear();
        for (ActivationResponseFilter filter : filters) {
            this.addActivationResponseFilter(filter);
        }
    }

    @Override
    public List<ActivationResponseFilter> getActivationResponseFilters() {
        return this._activationResponseFilters;
    }

    @Override
    public String getServerGuid() {
        return this._guid;
    }

    public void setServerGuid(String guid) {
        this._guid = guid;
    }

    @Override
    public void setSTSCertificates(List<X509Certificate> certificates) {
        this._stsCertificates = Collections.unmodifiableList(certificates);
    }

    @Override
    public List<X509Certificate> getSTSCertificates() {
        return this._stsCertificates;
    }

    @Override
    public VmodlContext getVmodlContext() {
        return this._context;
    }
}

