/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.impl;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vim.binding.vmodl.RuntimeFault;
import com.vmware.vim.binding.vmodl.fault.SystemError;
import com.vmware.vim.vmomi.core.ResponseContext;
import com.vmware.vim.vmomi.core.exception.MarshallException;
import com.vmware.vim.vmomi.core.exception.UnmarshallException;
import com.vmware.vim.vmomi.core.soap.Marshaller;
import com.vmware.vim.vmomi.core.soap.Unmarshaller;
import com.vmware.vim.vmomi.core.soap.impl.SoapHelper;
import com.vmware.vim.vmomi.core.types.ComplexType;
import com.vmware.vim.vmomi.core.types.ManagedMethod;
import com.vmware.vim.vmomi.core.types.ManagedObjectType;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlField;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import com.vmware.vim.vmomi.server.SoapBinding;
import com.vmware.vim.vmomi.server.impl.Fields;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SoapBindingImpl
implements SoapBinding {
    private static final Log _logger = LogFactory.getLog(SoapBindingImpl.class);
    private VmodlVersion _version;
    private Marshaller _marshaller;
    private Unmarshaller _unmarshaller;
    private Fields.ThisField _thisField;
    private VmodlContext _vmodlContext;

    public SoapBindingImpl(VmodlVersion version, VmodlContext vmodlContext) {
        this._version = version;
        this._vmodlContext = vmodlContext;
        this._unmarshaller = this._vmodlContext.createRequestUnmarshaller(this._version);
        this._marshaller = this._vmodlContext.createMarshaller(this._version);
        this._thisField = new Fields.ThisField(this._version);
    }

    @Override
    public VmodlVersion getVersion() {
        return this._version;
    }

    @Override
    public Object deserializeParam(VmodlField param, XMLStreamReader input) throws UnmarshallException {
        try {
            return this._unmarshaller.unmarshal(param, input);
        }
        catch (XMLStreamException e) {
            throw new UnmarshallException(String.format("Unable to deserialize parameter %1$s", param.getName()), (Throwable)e);
        }
    }

    @Override
    public ManagedObjectReference deserializeThisField(XMLStreamReader input) throws UnmarshallException {
        try {
            return (ManagedObjectReference)this._unmarshaller.unmarshal((VmodlField)this._thisField, input);
        }
        catch (XMLStreamException e) {
            throw new UnmarshallException("Unable to deserialize field 'this'", (Throwable)e);
        }
    }

    @Override
    public ManagedObjectType getMoType(ManagedObjectReference moRef) {
        VmodlType type = this._vmodlContext.getVmodlTypeMap().getLoadedVmodlType(moRef.getType());
        return type instanceof ManagedObjectType ? (ManagedObjectType)type : null;
    }

    @Override
    public void serializeFault(XMLStreamWriter xmlOut, ManagedMethod method, Exception fault) throws MarshallException {
        ComplexType faultType = null;
        VmodlType declaredType = null;
        if (fault instanceof MethodFault && (faultType = (ComplexType)this._vmodlContext.getVmodlTypeMap().getVmodlType(fault.getClass())) != null && (declaredType = method.getFault(faultType.getWsdlName())) == null) {
            declaredType = this.findDeclaredParent(method, faultType);
        }
        if (declaredType == null && !(fault instanceof RuntimeFault)) {
            fault = this.buildFaultForInvalidFault(method, fault, faultType);
        }
        String declaredWsdlName = fault instanceof RuntimeFault ? this._vmodlContext.getVmodlTypeMap().getVmodlType(RuntimeFault.class).getWsdlName() : declaredType.getWsdlName();
        this._marshaller.marshalSoapFault(fault, declaredWsdlName, xmlOut);
    }

    private VmodlType findDeclaredParent(ManagedMethod method, ComplexType faultType) {
        for (VmodlType type : method.getFaults()) {
            if (!faultType.isA((ComplexType)type)) continue;
            return type;
        }
        return null;
    }

    private Exception buildFaultForInvalidFault(ManagedMethod method, Exception fault, ComplexType faultType) {
        String faultTypeName = faultType == null ? fault.getClass().getName() : faultType.getWsdlName();
        SystemError newFault = new SystemError();
        newFault.setReason("Invalid fault");
        newFault.setMessage(faultTypeName);
        if (_logger.isErrorEnabled()) {
            _logger.error((Object)String.format("Method '%1$s' completed with undeclared fault of type '%2$s'", method.getName(), faultTypeName), (Throwable)fault);
        }
        return newFault;
    }

    @Override
    public void serializeResponse(XMLStreamWriter xmlOut, ManagedMethod method, Object result) throws XMLStreamException, MarshallException {
        FetchField retField;
        FetchField fetchField = retField = method.getManagedProperty() != null ? new FetchField(method.getResult()) : method.getResult();
        if (result == null && retField.getType() != null && !retField.isOptional()) {
            throw new MarshallException("Missing non-optional return value");
        }
        String replyTag = method.getManagedProperty() != null ? "FetchResponse" : method.getWsdlName() + "Response";
        SoapHelper.outputElementStart((XMLStreamWriter)xmlOut, (String)replyTag, (String)this._version.getNamespace(), (boolean)this._version.shouldMarshallNamespace());
        try {
            if (retField.getType() != null) {
                this._marshaller.marshal((VmodlField)retField, result, xmlOut);
            }
        }
        catch (MarshallException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MarshallException(String.format("Unable to serialize response for method %1$s", method.getName()), (Throwable)e);
        }
        xmlOut.writeEndElement();
    }

    @Override
    public void serializeHeader(XMLStreamWriter xmlOut, ResponseContext responseContext) throws XMLStreamException, MarshallException {
        SoapHelper.outputHeader((Marshaller)this._marshaller, (XMLStreamWriter)xmlOut, (Map)responseContext, (VmodlVersion)this._version, (VmodlContext)this._vmodlContext);
    }

    class FetchField
    implements VmodlField {
        private VmodlField _field;
        private static final String _returnVal = "returnval";
        private VmodlType _anyType;

        public FetchField(VmodlField field) {
            this._field = field;
            this._anyType = SoapBindingImpl.this._vmodlContext.getVmodlTypeMap().getVmodlType(Object.class);
        }

        public String getName() {
            return _returnVal;
        }

        public String getWsdlName() {
            return _returnVal;
        }

        public VmodlType getType() {
            return this._anyType;
        }

        public VmodlVersion getVersion() {
            return this._field.getVersion();
        }

        public String GetPrivilegeId() {
            return this._field.GetPrivilegeId();
        }

        public boolean isOptional() {
            return this._field.isOptional();
        }

        public VmodlType getManagedObjectType() {
            return this._field.getManagedObjectType();
        }

        public boolean isLink() {
            return this._field.isLink();
        }

        public boolean isLinkable() {
            return this._field.isLinkable();
        }

        public boolean isVisible(VmodlVersion version) {
            return this._field.isVisible(version);
        }

        public VmodlType getLinkType() {
            return this._field.getLinkType();
        }

        public boolean isSecret() {
            return this._field.isSecret();
        }

        public VmodlField.CollectionType getCollectionType() {
            return this._field.getCollectionType();
        }
    }
}

