/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.impl;

import com.vmware.vim.vmomi.server.Activation;
import com.vmware.vim.vmomi.server.ActivationValidator;
import com.vmware.vim.vmomi.server.common.DiagnosticContextProvider;
import com.vmware.vim.vmomi.server.common.ProcessingStep;
import com.vmware.vim.vmomi.server.exception.ExceptionUtil;
import com.vmware.vim.vmomi.server.impl.ValidationStartStep;
import com.vmware.vim.vmomi.server.impl.ValidatorFutureImpl;
import com.vmware.vim.vmomi.server.util.DiagnosticContextUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ValidationStartTask
implements Runnable,
DiagnosticContextProvider {
    private static final Log _logger = LogFactory.getLog(ValidationStartTask.class);
    private ValidationStartStep.ValidationInfo _validationInfo;
    private ProcessingStep<Activation> _nextStep;

    public ValidationStartTask(ValidationStartStep.ValidationInfo validationInfo, ProcessingStep<Activation> nextStep) {
        this._validationInfo = validationInfo;
        this._nextStep = nextStep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        AtomicInteger counter;
        Activation activation = this._validationInfo.getActivation();
        List<ActivationValidator> validators = this._validationInfo.getActivationValidators();
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)String.format("Starting activation validation for %1$s", activation.getRequest().getCorrelator()));
        }
        LinkedList<ValidatorFutureImpl> valFutures = new LinkedList<ValidatorFutureImpl>();
        AtomicInteger atomicInteger = counter = new AtomicInteger();
        synchronized (atomicInteger) {
            try {
                for (ActivationValidator validator : validators) {
                    ValidatorFutureImpl f = new ValidatorFutureImpl(activation, validators.size(), counter, this._nextStep);
                    valFutures.add(f);
                    validator.validate(activation, f);
                }
            }
            catch (RuntimeException e) {
                if (_logger.isErrorEnabled()) {
                    _logger.error((Object)String.format("Failed to start activation validation %1$d of %2$d, failing request", valFutures.size(), validators.size()), (Throwable)e);
                }
                for (ValidatorFutureImpl f : valFutures) {
                    f.cancel();
                }
                activation.getFutureArg().setException((Exception)ExceptionUtil.buildFaultForInternalException(e));
            }
        }
    }

    @Override
    public Map<String, Object> getDiagnosticContext() {
        return DiagnosticContextUtils.getDiagnosticContext(this._validationInfo.getActivation().getRequest().getRequestContext());
    }
}

