/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.impl.unmarshaller;

import com.vmware.vim.vmomi.core.exception.UnmarshallException;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.impl.VmodlContextImpl;
import com.vmware.vim.vmomi.server.impl.unmarshaller.StackContext;
import javax.xml.namespace.QName;

public class HeaderParamContext
extends StackContext {
    private QName _key;
    private String _value;
    private String _type;
    private boolean _mustUnderstand;

    public HeaderParamContext(QName key, String type, boolean mustUnderstand) {
        this._key = key;
        this._type = type;
        this._mustUnderstand = mustUnderstand;
    }

    @Override
    public void setValue(String value) throws UnmarshallException {
        this._value = value;
    }

    @Override
    public String getValue() {
        return this._value;
    }

    public String getKey() {
        return this._key.getLocalPart();
    }

    public String getNamespaceURI() {
        return this._key.getNamespaceURI();
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        this._type = type;
    }

    public Object getUnmarshalledValue() throws UnmarshallException {
        if (null != this._type) {
            VmodlType type = VmodlContextImpl.getCoreContext().getVmodlTypeMap().getVmodlType(this._type);
            if (type == null) {
                throw new UnmarshallException("Type " + this._type + " is not available in the core VmodlContext.");
            }
            if (type.getKind() != VmodlType.Kind.STRING && this._mustUnderstand) {
                throw new UnmarshallException("Unexpected type in request context: " + type.getKind());
            }
        }
        return this._value;
    }
}

