/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.mob.impl;

import com.vmware.vim.vmomi.server.mob.Response;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MobServletUtils {
    public static final String DEBUG_SESSION_COOKIE_NAME = "vmware_debug_session";

    public static void returnResponse(Response response, HttpServletRequest servletRequest, HttpServletResponse servletResponse, boolean is30Servlet) throws ServletException, IOException {
        String responseBody;
        String sessionId = response.getSessionCookie();
        if (sessionId != null) {
            Cookie sessionCookie = MobServletUtils.getSessionCookie(servletRequest);
            if (sessionCookie != null) {
                if (!sessionCookie.getValue().equals(sessionId)) {
                    sessionCookie.setValue(sessionId);
                    sessionCookie.setPath(MobServletUtils.getCookiePath(servletRequest));
                    sessionCookie.setSecure(servletRequest.isSecure());
                    if (is30Servlet) {
                        sessionCookie.setHttpOnly(true);
                    }
                    servletResponse.addCookie(sessionCookie);
                }
            } else {
                MobServletUtils.addSessionCookie(servletRequest, servletResponse, sessionId, is30Servlet);
            }
        }
        servletResponse.setContentType("text/html; charset=utf-8");
        if (response.isAuthChallenge()) {
            MobServletUtils.sendAuthChallenge(servletResponse, response.getAuthChallengeRealm());
        } else if (response.isRedirect()) {
            servletResponse.sendRedirect(response.getRedirect());
        } else if (response.isServerFault()) {
            if (response.getResponseBody() == null) {
                servletResponse.sendError(response.getServerFault());
            } else {
                servletResponse.setStatus(response.getServerFault());
                responseBody = response.getResponseBody();
                servletResponse.getWriter().print(responseBody);
            }
        } else {
            servletResponse.setStatus(200);
            responseBody = response.getResponseBody();
            servletResponse.getWriter().print(responseBody);
        }
    }

    public static Cookie getSessionCookie(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!DEBUG_SESSION_COOKIE_NAME.equals(cookie.getName())) continue;
            return cookie;
        }
        return null;
    }

    private static void sendAuthChallenge(HttpServletResponse response, String realm) throws IOException {
        response.setHeader("WWW-Authenticate", "Basic realm=\"" + realm + "\"");
        response.sendError(401);
    }

    private static void addSessionCookie(HttpServletRequest servletRequest, HttpServletResponse servletResponse, String sessionId, boolean is30Servlet) {
        Cookie cookie = new Cookie(DEBUG_SESSION_COOKIE_NAME, sessionId);
        cookie.setPath(MobServletUtils.getCookiePath(servletRequest));
        cookie.setSecure(servletRequest.isSecure());
        if (is30Servlet) {
            cookie.setHttpOnly(true);
        }
        servletResponse.addCookie(cookie);
    }

    private static String getCookiePath(HttpServletRequest servletRequest) {
        if (servletRequest.getContextPath() != null && !servletRequest.getContextPath().isEmpty()) {
            return servletRequest.getContextPath();
        }
        return "/";
    }
}

