/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.mob.impl;

import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.impl.BlockingFuture;
import com.vmware.vim.vmomi.core.types.ComplexType;
import com.vmware.vim.vmomi.core.types.ComplexTypeField;
import com.vmware.vim.vmomi.core.types.ManagedMethod;
import com.vmware.vim.vmomi.core.types.ManagedObjectType;
import com.vmware.vim.vmomi.core.types.ManagedProperty;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import com.vmware.vim.vmomi.server.LocalClient;
import com.vmware.vim.vmomi.server.session.Session;
import java.lang.reflect.Array;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectGetter {
    private static Log _logger = LogFactory.getLog(ObjectGetter.class);
    private LocalClient _localClient;
    private VmodlVersion _version;
    private Session _session;
    private final VmodlContext _context;

    public ObjectGetter(LocalClient localClient, VmodlVersion version, Session session, VmodlContext context) {
        this._localClient = localClient;
        this._version = version;
        this._session = session;
        this._context = context;
    }

    private ParsedProperty parseProperty(String prop) {
        ParsedProperty result = new ParsedProperty();
        if (prop.indexOf("[\"") != -1) {
            result.baseProp = prop.substring(0, prop.indexOf("["));
            result.key = prop.substring(prop.indexOf("[") + 2, prop.indexOf("\"]"));
        } else if (prop.indexOf("[") != -1) {
            result.baseProp = prop.substring(0, prop.indexOf("["));
            result.key = new Integer(prop.substring(prop.indexOf("[") + 1, prop.indexOf("]")));
        } else {
            result.baseProp = prop;
            result.key = null;
        }
        return result;
    }

    private Object findItemWithKey(Object array, Object key) {
        if (!array.getClass().isArray()) {
            if (_logger.isErrorEnabled()) {
                _logger.error((Object)"Object is not an array");
            }
            return null;
        }
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Object itemKey;
            Object item = Array.get(array, i);
            ComplexType itemType = (ComplexType)this._context.getVmodlTypeMap().getDynamicVmodlType(item);
            try {
                itemKey = itemType.getProperty("key").get(item);
            }
            catch (Exception e) {
                if (_logger.isErrorEnabled()) {
                    _logger.error((Object)String.format("Cannot get value from %s at path 'key'", itemType.getWsdlName()), (Throwable)e);
                }
                return null;
            }
            if (key.equals(itemKey)) {
                return item;
            }
            if (!(itemKey instanceof ManagedObjectReference) || !key.equals(((ManagedObjectReference)itemKey).getValue())) continue;
            return item;
        }
        if (_logger.isErrorEnabled()) {
            _logger.error((Object)("Could not find object in array with key " + key));
        }
        return null;
    }

    private Object getPropertyFromManagedObject(ManagedObject mObject, String prop) {
        Object obj;
        ManagedObjectType moType = (ManagedObjectType)this._context.getVmodlTypeMap().getDynamicVmodlType((Object)mObject);
        if (moType == null) {
            if (_logger.isErrorEnabled()) {
                _logger.error((Object)"Requested managed object is not a VMODL type");
            }
            return null;
        }
        ParsedProperty parsedProp = this.parseProperty(prop);
        ManagedProperty p = moType.getManagedProperty(parsedProp.baseProp);
        if (p == null) {
            if (_logger.isErrorEnabled()) {
                _logger.error((Object)String.format("No property in type %s at path %s", moType.getWsdlName(), parsedProp.baseProp));
            }
            return null;
        }
        ManagedMethod getter = p.getAccessor();
        BlockingFuture f = new BlockingFuture();
        try {
            this._localClient.invoke(mObject, getter, new Object[0], this._version, this._session, (Future)f);
            obj = f.get();
        }
        catch (Exception e) {
            if (_logger.isErrorEnabled()) {
                _logger.error((Object)("Cannot get value from " + moType.getWsdlName() + " at path " + parsedProp.baseProp), (Throwable)e);
            }
            return null;
        }
        if (parsedProp.key != null) {
            return this.findItemWithKey(obj, parsedProp.key);
        }
        return obj;
    }

    private Object getPropertyFromComplexObject(Object cObject, String prop) {
        Object obj;
        VmodlType type = this._context.getVmodlTypeMap().getDynamicVmodlType(cObject);
        if (type == null || !(type instanceof ComplexType)) {
            if (_logger.isErrorEnabled()) {
                _logger.error((Object)"Requested complex object is not a VMODL type");
            }
            return null;
        }
        ComplexType cType = (ComplexType)type;
        ParsedProperty parsedProp = this.parseProperty(prop);
        try {
            ComplexTypeField field = cType.getProperty(parsedProp.baseProp);
            obj = field.get(cObject);
        }
        catch (Exception e) {
            if (_logger.isErrorEnabled()) {
                _logger.error((Object)String.format("Cannot get value from %s at path %s", type.getWsdlName(), parsedProp.baseProp), (Throwable)e);
            }
            return null;
        }
        if (parsedProp.key != null) {
            return this.findItemWithKey(obj, parsedProp.key);
        }
        return obj;
    }

    public Object getObjectAtPath(ManagedObject mObject, String doPath) {
        StringTokenizer st = new StringTokenizer(doPath, ".");
        if (!st.hasMoreTokens()) {
            return null;
        }
        String prop = st.nextToken();
        Object obj = this.getPropertyFromManagedObject(mObject, prop);
        while (obj != null && st.hasMoreTokens()) {
            prop = st.nextToken();
            obj = this.getPropertyFromComplexObject(obj, prop);
        }
        if (obj == null && _logger.isErrorEnabled()) {
            _logger.error((Object)String.format("Cannot get value from %s at path %s", mObject._getRef().getValue(), doPath));
        }
        return obj;
    }

    private static class ParsedProperty {
        private String baseProp;
        private Object key;

        private ParsedProperty() {
        }
    }
}

