/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.mob.impl;

import com.vmware.vim.vmomi.server.mob.Authenticator;
import com.vmware.vim.vmomi.server.mob.impl.AuthenticatorFutureImpl;
import com.vmware.vim.vmomi.server.session.Session;
import com.vmware.vim.vmomi.server.session.SessionAuthData;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RequestCredentials {
    private final Log _logger = LogFactory.getLog(this.getClass());
    private final HttpServletRequest _request;
    private String _username;
    private String _password;

    public RequestCredentials(HttpServletRequest request) {
        this._request = request;
    }

    public SessionAuthData authenticate(Authenticator authenticator, Session session) {
        if (!this.parseBasicCredentials()) {
            if (this._logger.isWarnEnabled()) {
                this._logger.warn((Object)"No credentials supplied");
            }
            return null;
        }
        AuthenticatorFutureImpl f = new AuthenticatorFutureImpl(session);
        authenticator.authenticate(this._username, this._password, f);
        SessionAuthData authData = f.getSessionAuthData();
        if (authData == null && session.getAuthData() == null) {
            if (this._logger.isWarnEnabled()) {
                this._logger.warn((Object)"Invalid username and password");
            }
        } else if (this._logger.isDebugEnabled()) {
            this._logger.debug((Object)"User is authenticated");
        }
        return authData;
    }

    private boolean parseBasicCredentials() {
        String authHeader = this._request.getHeader("Authorization");
        if (authHeader == null) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(authHeader);
        if (!st.hasMoreTokens()) {
            return false;
        }
        String basic = st.nextToken();
        if (!basic.equalsIgnoreCase("Basic")) {
            return false;
        }
        if (!st.hasMoreTokens()) {
            return false;
        }
        String encodedCredentials = st.nextToken();
        if (st.hasMoreTokens()) {
            return false;
        }
        String decodedCredentials = new String(Base64.decodeBase64((byte[])encodedCredentials.getBytes()));
        int index = decodedCredentials.indexOf(":");
        if (index == -1) {
            return false;
        }
        this._username = decodedCredentials.substring(0, index);
        this._password = decodedCredentials.substring(index + 1);
        return true;
    }
}

