/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.mob.impl;

import com.vmware.vim.binding.impl.vmodl.BinaryImpl;
import com.vmware.vim.binding.impl.vmodl.MethodNameImpl;
import com.vmware.vim.binding.impl.vmodl.TypeNameImpl;
import com.vmware.vim.binding.vmodl.Binary;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodName;
import com.vmware.vim.binding.vmodl.PropertyPath;
import com.vmware.vim.binding.vmodl.TypeName;
import com.vmware.vim.vmomi.core.exception.InternalException;
import com.vmware.vim.vmomi.core.soap.Marshaller;
import com.vmware.vim.vmomi.core.types.ComplexType;
import com.vmware.vim.vmomi.core.types.ComplexTypeField;
import com.vmware.vim.vmomi.core.types.VmodlArrayType;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlEnumType;
import com.vmware.vim.vmomi.core.types.VmodlField;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import com.vmware.vim.vmomi.core.types.impl.VmodlFieldImpl;
import com.vmware.vim.vmomi.core.util.XMLPrettyPrinterFactory;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SampleValueGenerator {
    private static final Log LOG = LogFactory.getLog((String)SampleValueGenerator.class.getName());
    private static final String SAMPLE_STRING = "Sample";
    private static final String SAMPLE_ANY = "ANY";
    private static final PropertyPath SAMPLE_PROPERTY_PATH = new PropertyPath("Property.Path");
    private static final URI SAMPLE_URI;
    private static final Binary SAMPLE_BINARY;
    private static final boolean[] SAMPLE_BOOLEAN_ARRAY;
    private static final int[] SAMPLE_INT_ARRAY;
    private static final byte[] SAMPLE_BYTE_ARRAY;
    private static final double[] SAMPLE_DOUBLE_ARRAY;
    private static final float[] SMAPLE_FLOAT_ARRAY;
    private static final short[] SMAPLE_SHORT_ARRAY;
    private static final long[] SMAPLE_LONG_ARRAY;
    private static final MethodName SAMPLE_METHOD_NAME;
    private static final TypeName SAMPLE_TYPE_NAME;
    private final VmodlVersion _version;
    private final String _indent;
    private final String _newLine;
    private final VmodlContext _context;

    @Deprecated
    public SampleValueGenerator(VmodlVersion version, String indent, String newLine) {
        this(version, indent, newLine, VmodlContext.getContext());
    }

    public SampleValueGenerator(VmodlVersion version, String indent, String newLine, VmodlContext context) {
        this._version = version;
        this._indent = indent;
        this._newLine = newLine;
        this._context = context;
    }

    public String generateSampleValue(VmodlField field) {
        try {
            Object value = this.generateAny(field, 0);
            if (this.isPrimitive(field.getType())) {
                return value.toString();
            }
            StringWriter writer = new StringWriter();
            XMLOutputFactory factory = XMLOutputFactory.newInstance();
            factory.setProperty("javax.xml.stream.isRepairingNamespaces", true);
            XMLStreamWriter output = XMLPrettyPrinterFactory.createXMLStreamWriter((XMLStreamWriter)factory.createXMLStreamWriter(writer), (String)this._indent, (String)this._newLine);
            Marshaller marshaller = this._context.createMarshaller(this._version);
            marshaller.marshal(field, value, output);
            return writer.toString();
        }
        catch (Exception e) {
            LOG.error((Object)String.format("Error generating sample value for field %s of type %s", field.getName(), field.getType()), (Throwable)e);
            return "Error: " + e;
        }
    }

    private boolean isPrimitive(VmodlType type) {
        switch (type.getKind()) {
            case BOOL: 
            case INT: 
            case BYTE: 
            case DOUBLE: 
            case FLOAT: 
            case SHORT: 
            case LONG: 
            case STRING: 
            case TYPE_NAME: 
            case METHOD_NAME: 
            case PROPERTY_PATH: 
            case ANY: 
            case ENUM: 
            case DATETIME: 
            case URI: 
            case BINARY: {
                return true;
            }
            case MOREF: 
            case ARRAY: 
            case FAULT: 
            case DATA_OBJECT: {
                return false;
            }
        }
        throw new InternalException(String.format("Unsupported type kind %s", type.getKind()));
    }

    private Object generateAny(VmodlField field, int depth) {
        VmodlType type = field.getType();
        switch (type.getKind()) {
            case BOOL: {
                return Boolean.FALSE;
            }
            case INT: {
                return 42;
            }
            case BYTE: {
                return (byte)42;
            }
            case DOUBLE: {
                return 42.0;
            }
            case FLOAT: {
                return Float.valueOf(42.0f);
            }
            case SHORT: {
                return (short)42;
            }
            case LONG: {
                return 42L;
            }
            case STRING: {
                return SAMPLE_STRING;
            }
            case TYPE_NAME: {
                return SAMPLE_TYPE_NAME;
            }
            case METHOD_NAME: {
                return SAMPLE_METHOD_NAME;
            }
            case PROPERTY_PATH: {
                return SAMPLE_PROPERTY_PATH;
            }
            case ANY: {
                return SAMPLE_ANY;
            }
            case URI: {
                return SAMPLE_URI;
            }
            case BINARY: {
                return SAMPLE_BINARY;
            }
            case ENUM: {
                VmodlEnumType enumType = (VmodlEnumType)type;
                return enumType.getTypeClass().getEnumConstants()[0];
            }
            case DATETIME: {
                return Calendar.getInstance();
            }
            case MOREF: {
                ManagedObjectReference ref = new ManagedObjectReference(field.getManagedObjectType().getWsdlName(), "MOID", "Server GUID");
                return ref;
            }
            case ARRAY: {
                return this.generateArray(field, depth);
            }
            case FAULT: 
            case DATA_OBJECT: {
                return this.generateComplexObject(field, depth);
            }
        }
        throw new InternalException(String.format("Unsupported type kind %s", type.getKind()));
    }

    private Object generateComplexObject(VmodlField field, int depth) {
        ComplexType doType = (ComplexType)field.getType();
        Object obj = doType.newInstance();
        for (ComplexTypeField doField : doType.getProperties()) {
            String name = doField.getName();
            if (doField.isOptional() && depth > 3 || doField.isOptional() && ("dynamicProperty".equals(name) || "dynamicType".equals(name))) continue;
            Object val = this.generateAny((VmodlField)doField, depth + 1);
            doField.set(obj, val);
        }
        return obj;
    }

    private Object generateArray(VmodlField field, int depth) {
        VmodlType type = field.getType();
        VmodlType compType = ((VmodlArrayType)type).getComponentType();
        switch (compType.getKind()) {
            case BOOL: {
                return SAMPLE_BOOLEAN_ARRAY;
            }
            case INT: {
                return SAMPLE_INT_ARRAY;
            }
            case BYTE: {
                return SAMPLE_BYTE_ARRAY;
            }
            case DOUBLE: {
                return SAMPLE_DOUBLE_ARRAY;
            }
            case FLOAT: {
                return SMAPLE_FLOAT_ARRAY;
            }
            case SHORT: {
                return SMAPLE_SHORT_ARRAY;
            }
            case LONG: {
                return SMAPLE_LONG_ARRAY;
            }
            case STRING: 
            case TYPE_NAME: 
            case METHOD_NAME: 
            case PROPERTY_PATH: 
            case ANY: 
            case ENUM: 
            case DATETIME: 
            case URI: 
            case BINARY: 
            case MOREF: 
            case FAULT: 
            case DATA_OBJECT: {
                try {
                    VmodlFieldImpl compField = new VmodlFieldImpl(this._context);
                    compField.setType(compType);
                    if (compType.getKind() == VmodlType.Kind.MOREF) {
                        String moClazz = field.getManagedObjectType().getTypeClass().getName();
                        compField.setManagedObjectClassName(moClazz);
                    }
                    Object[] array = (Object[])Array.newInstance(compType.getTypeClass(), 1);
                    array[0] = this.generateAny((VmodlField)compField, depth + 1);
                    return array;
                }
                catch (Exception e) {
                    throw new InternalException(String.format("Unable to generate array for field %1$s", field.getName()), (Throwable)e);
                }
            }
        }
        throw new InternalException(String.format("Unsupported array component type kind %s", type.getKind()));
    }

    static {
        try {
            SAMPLE_URI = new URI("http://example.com/path");
        }
        catch (URISyntaxException e) {
            throw new ExceptionInInitializerError(e);
        }
        SAMPLE_BINARY = new BinaryImpl(new byte[]{-34, -83, -64, -34});
        SAMPLE_BOOLEAN_ARRAY = new boolean[]{false};
        SAMPLE_INT_ARRAY = new int[]{42};
        SAMPLE_BYTE_ARRAY = new byte[]{42};
        SAMPLE_DOUBLE_ARRAY = new double[]{42.0};
        SMAPLE_FLOAT_ARRAY = new float[]{42.0f};
        SMAPLE_SHORT_ARRAY = new short[]{42};
        SMAPLE_LONG_ARRAY = new long[]{42L};
        SAMPLE_METHOD_NAME = new MethodNameImpl("MethodName");
        SAMPLE_TYPE_NAME = new TypeNameImpl("TypeName");
    }
}

