/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.session.impl;

import com.vmware.vim.vmomi.core.util.SHA1HashGenerator;
import com.vmware.vim.vmomi.server.session.Session;
import com.vmware.vim.vmomi.server.session.SessionManager;
import com.vmware.vim.vmomi.server.session.impl.SessionImpl;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Queue;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Reaper
implements Runnable {
    private static final Log LOG = LogFactory.getLog(Reaper.class);
    private final Queue<Runnable> _tasks;
    private final SortedSet<Session> _expirationSet;
    private final Thread _reaperThread;
    private volatile boolean _stop = false;
    private SessionManager _sessionManager;

    Reaper(SessionManager sessionManager) {
        this._sessionManager = sessionManager;
        this._tasks = new ConcurrentLinkedQueue<Runnable>();
        this._expirationSet = new TreeSet<Session>(new SessionComparator());
        this._reaperThread = new Thread((Runnable)this, "VLSI-session-reaper");
        this._reaperThread.start();
    }

    void requestClosing(final SessionImpl session) {
        this.schedule(new Runnable(){

            @Override
            public void run() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Closing session objects " + SHA1HashGenerator.generateTruncated((String)session.getId())));
                }
                session.closeSessionObjects();
                Reaper.this._expirationSet.remove(session);
            }
        });
    }

    void requestExpirationChange(final SessionImpl session, final long newExpirationMs) {
        this.schedule(new Runnable(){

            @Override
            public void run() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Changing expiration date for session " + SHA1HashGenerator.generateTruncated((String)session.getId()) + " to " + newExpirationMs));
                }
                Reaper.this._expirationSet.remove(session);
                session.setExpirationDateMs(newExpirationMs);
                if (newExpirationMs != Long.MAX_VALUE) {
                    Reaper.this._expirationSet.add(session);
                }
            }
        });
    }

    private void schedule(Runnable task) {
        this._tasks.add(task);
        this._reaperThread.interrupt();
    }

    public void stop(boolean doWait) {
        this._stop = true;
        this._reaperThread.interrupt();
        if (doWait) {
            try {
                this._reaperThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (doWait && this._reaperThread.isAlive() && LOG.isWarnEnabled()) {
            LOG.warn((Object)"Could not shutdown the reaper thread.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this._stop) {
            long sleepInterval;
            Session session;
            Runnable task;
            LOG.debug((Object)"Processing changes");
            while ((task = this._tasks.poll()) != null) {
                task.run();
            }
            long now = System.currentTimeMillis();
            Iterator iter = this._expirationSet.iterator();
            while (iter.hasNext() && (session = (Session)iter.next()).getExpirationDateMs() <= now) {
                SessionManager sessionManager = this._sessionManager;
                synchronized (sessionManager) {
                    Object object = ((SessionImpl)session).lock;
                    synchronized (object) {
                        if (((SessionImpl)session).getUseCount() > 0) {
                            iter.remove();
                            continue;
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Expiring session " + SHA1HashGenerator.generateTruncated((String)session.getId()) + '(' + session.getExpirationDateMs() + " < " + now + ')'));
                        }
                        session.closeSession();
                        iter.remove();
                    }
                }
            }
            long l = sleepInterval = !this._expirationSet.isEmpty() ? this._expirationSet.first().getExpirationDateMs() - now : Long.MAX_VALUE;
            if (this._stop) continue;
            try {
                Thread.sleep(sleepInterval);
            }
            catch (InterruptedException e) {}
        }
    }

    private static class SessionComparator
    implements Comparator<Session> {
        private SessionComparator() {
        }

        @Override
        public int compare(Session lhs, Session rhs) {
            long right;
            long left = lhs.getExpirationDateMs();
            return left < (right = rhs.getExpirationDateMs()) ? -1 : (left > right ? 1 : lhs.getId().compareTo(rhs.getId()));
        }
    }
}

