/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.util;

import com.vmware.vim.vmomi.server.common.DiagnosticContextProvider;
import com.vmware.vim.vmomi.server.common.ThreadConfigurator;
import java.util.Map;
import org.apache.log4j.MDC;

public class Log4jMDCThreadConfigurator
implements ThreadConfigurator {
    @Override
    public void before(Runnable r) {
        Map<String, Object> diagnosticContext;
        DiagnosticContextProvider dcp = this.getDiagnosticContext(r);
        if (dcp != null && dcp.getDiagnosticContext() != null && (diagnosticContext = dcp.getDiagnosticContext()) != null) {
            for (String key : diagnosticContext.keySet()) {
                MDC.put((String)key, (Object)diagnosticContext.get(key));
            }
        }
    }

    @Override
    public void after(Runnable r) {
        DiagnosticContextProvider dcp = this.getDiagnosticContext(r);
        if (dcp != null && dcp.getDiagnosticContext() != null) {
            for (String key : dcp.getDiagnosticContext().keySet()) {
                MDC.remove((String)key);
            }
        }
    }

    private DiagnosticContextProvider getDiagnosticContext(Runnable r) {
        if (r instanceof DiagnosticContextProvider) {
            return (DiagnosticContextProvider)((Object)r);
        }
        return null;
    }
}

