/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.data;

import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.data.ConstraintValidationException;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.OptionalValue;
import com.vmware.vapi.data.StringValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.data.ConstraintValidator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class UnionValidator
implements ConstraintValidator {
    private final String discriminantFieldName;
    private final Map<String, List<FieldData>> caseFields;
    private final Set<FieldData> allUnionFields;

    public UnionValidator(String discriminantFieldName, Map<String, List<FieldData>> caseFields) {
        Validate.notNull((Object)discriminantFieldName);
        Validate.notNull(caseFields);
        for (List<FieldData> list : caseFields.values()) {
            Validate.notNull(list);
        }
        this.discriminantFieldName = discriminantFieldName;
        this.caseFields = caseFields;
        this.allUnionFields = new HashSet<FieldData>();
        for (Map.Entry entry : caseFields.entrySet()) {
            this.allUnionFields.addAll((Collection)entry.getValue());
        }
    }

    @Override
    public void validate(DataValue dataValue) {
        Validate.isTrue((boolean)(dataValue instanceof StructValue));
        StructValue structValue = (StructValue)dataValue;
        DataValue discriminantValue = null;
        if (structValue.hasField(this.discriminantFieldName)) {
            discriminantValue = structValue.getField(this.discriminantFieldName);
        }
        if (this.isMissingOrUnsetOptionalValue(discriminantValue)) {
            this.validateOtherFieldsAreNotSet(structValue, Collections.emptyList());
            return;
        }
        if (discriminantValue instanceof OptionalValue) {
            discriminantValue = ((OptionalValue)discriminantValue).getValue();
        }
        Validate.isTrue((boolean)(discriminantValue instanceof StringValue));
        List<FieldData> expectedFields = this.caseFields.get(((StringValue)discriminantValue).getValue());
        if (expectedFields == null) {
            expectedFields = Collections.emptyList();
        }
        this.validateExpectedFieldsAreSet(structValue, expectedFields);
        this.validateOtherFieldsAreNotSet(structValue, expectedFields);
    }

    void validateExpectedFieldsAreSet(StructValue struct, List<FieldData> expectedFields) {
        for (FieldData expField : expectedFields) {
            if (expField.isOptional()) continue;
            DataValue fieldValue = null;
            if (struct.hasField(expField.getName())) {
                fieldValue = struct.getField(expField.getName());
            }
            if (!this.isMissingOrUnsetOptionalValue(fieldValue)) continue;
            throw new ConstraintValidationException(MessageFactory.getMessage("vapi.data.structure.union.missing", struct.getName(), expField.getName()));
        }
    }

    void validateOtherFieldsAreNotSet(StructValue struct, List<FieldData> expectedFields) {
        HashSet<FieldData> otherFields = new HashSet<FieldData>(this.allUnionFields);
        otherFields.removeAll(expectedFields);
        for (FieldData otherField : otherFields) {
            DataValue fieldValue = null;
            if (struct.hasField(otherField.getName())) {
                fieldValue = struct.getField(otherField.getName());
            }
            if (this.isMissingOrUnsetOptionalValue(fieldValue)) continue;
            throw new ConstraintValidationException(MessageFactory.getMessage("vapi.data.structure.union.extra", struct.getName(), otherField.getName()));
        }
    }

    private boolean isMissingOrUnsetOptionalValue(DataValue dataValue) {
        if (dataValue == null) {
            return true;
        }
        if (dataValue instanceof OptionalValue) {
            return !((OptionalValue)dataValue).isSet();
        }
        return false;
    }

    public static final class FieldData {
        private final String name;
        private final boolean isOptional;

        public FieldData(String name, boolean isOptional) {
            Validate.notEmpty((String)name);
            this.name = name;
            this.isOptional = isOptional;
        }

        public String getName() {
            return this.name;
        }

        public boolean isOptional() {
            return this.isOptional;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.isOptional ? 1231 : 1237);
            result = 31 * result + this.name.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FieldData other = (FieldData)obj;
            if (this.isOptional != other.isOptional) {
                return false;
            }
            return this.name.equals(other.name);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "<" + this.name + ", " + this.isOptional + ">";
        }
    }
}

