/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.dsig.json;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public final class CanonicalizationUtil {
    private static final ThreadLocal<DecimalFormat> decimalFormatPerThread = new ThreadLocal<DecimalFormat>(){

        @Override
        protected DecimalFormat initialValue() {
            DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.US);
            DecimalFormat df = new DecimalFormat("0.0E0", symbols);
            df.setMaximumFractionDigits(Integer.MAX_VALUE);
            return df;
        }
    };

    public static String canonicalizeDouble(double value) {
        if (Double.isInfinite(value) || Double.isNaN(value)) {
            throw new IllegalArgumentException("JSON does not permit numeric values that cannot be represented as sequences of digits (such as Infinity and NaN)");
        }
        return decimalFormatPerThread.get().format(value);
    }
}

