/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.rpc.http;

import com.vmware.vapi.client.exception.TransportProtocolException;
import com.vmware.vapi.internal.util.io.IoUtil;
import java.io.IOException;
import org.apache.commons.lang.Validate;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;

public final class ApacheHttpUtil {
    public static final String VAPI_USER_AGENT = "vAPI http client";

    private ApacheHttpUtil() {
    }

    public static void validateHttpResponse(HttpResponse httpResponse, String requestContentType) {
        boolean expectedContentType;
        Validate.notNull((Object)httpResponse);
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        if (300 <= statusCode && statusCode <= 399) {
            throw new TransportProtocolException(String.format("HTTP redirect response with status code %d (enable debug logging for details)", statusCode));
        }
        HttpEntity entity = httpResponse.getEntity();
        if (entity == null) {
            throw new TransportProtocolException(String.format("HTTP response with status code %d and no content (enable debug logging for details)", statusCode));
        }
        String contentType = null;
        if (entity.getContentType() != null) {
            contentType = ApacheHttpUtil.stripContentTypeParams(entity.getContentType().getValue());
        }
        if (400 <= statusCode && statusCode <= 599) {
            String text = ApacheHttpUtil.getText(entity, contentType);
            if (text != null) {
                throw new TransportProtocolException(String.format("HTTP response with status code %d (enable debug logging for details): %s", statusCode, text));
            }
            throw new TransportProtocolException(String.format("HTTP response with status code %d (enable debug logging for details)", statusCode));
        }
        if (contentType == null) {
            throw new TransportProtocolException(String.format("HTTP response with status code %d and no Content-Type header (enable debug logging for details)", statusCode));
        }
        boolean bl = expectedContentType = requestContentType.equals(contentType) || "application/vnd.vmware.vapi.framed".equals(contentType);
        if (!expectedContentType) {
            String text = ApacheHttpUtil.getText(entity, contentType);
            if (text != null) {
                throw new TransportProtocolException(String.format("HTTP response with status code %d has unexpected content-type '%s' (enable debug logging for details): %s", statusCode, contentType, text));
            }
            throw new TransportProtocolException(String.format("HTTP response with status code %d has unexpected content-type '%s' (enable debug logging for details)", statusCode, contentType));
        }
    }

    static String stripContentTypeParams(String contentType) {
        if (contentType == null) {
            return null;
        }
        int semiColonIndex = contentType.indexOf(59);
        if (semiColonIndex >= 0) {
            contentType = contentType.substring(0, semiColonIndex);
        }
        return contentType.trim();
    }

    private static String getText(HttpEntity entity, String contentType) {
        String text;
        if (contentType == null) {
            return null;
        }
        if (!contentType.contains("text")) {
            return null;
        }
        try {
            text = new String(IoUtil.readAll(entity.getContent()), "UTF-8");
        }
        catch (IOException ex) {
            text = null;
        }
        return text;
    }
}

