/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.util;

import com.vmware.vapi.CoreException;
import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.data.ConstraintValidationException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DateTimeConverter {
    private static final TimeZone UTC_ZONE = TimeZone.getTimeZone("GMT+00:00");
    private static final Date PURE_GREGORIAN_CHANGE = new Date(Long.MIN_VALUE);
    private static final String DATETIME_PATTERN_STRING = "(\\d{4})-(\\d{2})-(\\d{2})T(\\d{2}):(\\d{2}):(\\d{2}).(\\d{3})Z";
    private static final Pattern DATETIME_PATTERN = Pattern.compile("(\\d{4})-(\\d{2})-(\\d{2})T(\\d{2}):(\\d{2}):(\\d{2}).(\\d{3})Z");
    private static final String DATETIME_FORMATTER_STRING = "%1$tY-%1$tm-%1$tdT%1$tH:%1$tM:%1$tS.%1$tLZ";

    public Calendar fromStringValue(String datetime) {
        Matcher m = DATETIME_PATTERN.matcher(datetime);
        if (!m.matches()) {
            throw new ConstraintValidationException(MessageFactory.getMessage("vapi.bindings.typeconverter.datetime.deserialize.invalid.format", datetime, DATETIME_PATTERN_STRING));
        }
        int year = Integer.parseInt(m.group(1));
        int month = Integer.parseInt(m.group(2));
        int day = Integer.parseInt(m.group(3));
        int hour = Integer.parseInt(m.group(4));
        int minute = Integer.parseInt(m.group(5));
        int second = Integer.parseInt(m.group(6));
        int millisecond = Integer.parseInt(m.group(7));
        if (year <= 0) {
            throw new ConstraintValidationException(MessageFactory.getMessage("vapi.bindings.typeconverter.datetime.deserialize.year.bc", datetime));
        }
        if (month < 1 || month > 12) {
            throw new ConstraintValidationException(MessageFactory.getMessage("vapi.bindings.typeconverter.datetime.deserialize.month.invalid", datetime));
        }
        if (day < 1 || day > 31) {
            throw new ConstraintValidationException(MessageFactory.getMessage("vapi.bindings.typeconverter.datetime.deserialize.day.invalid", datetime));
        }
        if (hour > 23) {
            throw new ConstraintValidationException(MessageFactory.getMessage("vapi.bindings.typeconverter.datetime.deserialize.hour.invalid", datetime));
        }
        if (minute > 59) {
            throw new ConstraintValidationException(MessageFactory.getMessage("vapi.bindings.typeconverter.datetime.deserialize.minute.invalid", datetime));
        }
        if (second > 59) {
            throw new ConstraintValidationException(MessageFactory.getMessage("vapi.bindings.typeconverter.datetime.deserialize.second.invalid", datetime));
        }
        try {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.clear();
            calendar.setLenient(false);
            calendar.setGregorianChange(PURE_GREGORIAN_CHANGE);
            calendar.setTimeZone(UTC_ZONE);
            calendar.set(1, year);
            calendar.set(2, month - 1);
            calendar.set(5, day);
            calendar.set(11, hour);
            calendar.set(12, minute);
            calendar.set(13, second);
            calendar.set(14, millisecond);
            calendar.getTimeInMillis();
            return calendar;
        }
        catch (RuntimeException ex) {
            throw new ConstraintValidationException(MessageFactory.getMessage("vapi.bindings.typeconverter.datetime.deserialize.invalid.time", datetime, ex.getMessage()), (Throwable)ex);
        }
    }

    public String toStringValue(Calendar calendar) {
        GregorianCalendar utcCalendar = DateTimeConverter.toUtcCalendar(calendar);
        if (DateTimeConverter.isYearBC(utcCalendar)) {
            throw new CoreException(MessageFactory.getMessage("vapi.bindings.typeconverter.datetime.serialize.year.bc", calendar.toString()));
        }
        if (utcCalendar.get(1) > 9999) {
            throw new CoreException(MessageFactory.getMessage("vapi.bindings.typeconverter.datetime.serialize.year.too.big", calendar.toString()));
        }
        return String.format(DATETIME_FORMATTER_STRING, utcCalendar);
    }

    private static boolean isYearBC(GregorianCalendar c) {
        return c.get(0) == 0;
    }

    private static GregorianCalendar toUtcCalendar(Calendar calendar) {
        GregorianCalendar utcCalendar = new GregorianCalendar();
        utcCalendar.clear();
        utcCalendar.setGregorianChange(PURE_GREGORIAN_CHANGE);
        utcCalendar.setTimeZone(UTC_ZONE);
        utcCalendar.setTimeInMillis(calendar.getTimeInMillis());
        return utcCalendar;
    }
}

