/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vwcsdktools.handlers;

import com.vmware.vide.vwcsdktools.managers.MetadataTagProjectDataManager;
import com.vmware.vide.vwcsdktools.utils.Runners;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class ActionScriptChangeListener
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent event) {
        Set<IFile> fileChanged = this.getChangedActionScripts(event);
        for (final IFile file : fileChanged) {
            IProject project = file.getProject();
            if (!MetadataTagProjectDataManager.INSTANCE.runCheckerAtSave(project)) continue;
            Job job = new Job("Metadata Tag Checker"){

                protected IStatus run(IProgressMonitor monitor) {
                    Runners.runMetadataChecker(file);
                    return new Status(0, "com.vmware.vide.vwcsdktools", "");
                }
            };
            job.setUser(false);
            job.schedule();
        }
    }

    private Set<IFile> getChangedActionScripts(IResourceChangeEvent event) {
        final HashSet<IFile> fileChanged = new HashSet<IFile>();
        try {
            event.getDelta().accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    if (delta.getResource() instanceof IFile) {
                        IFile file = (IFile)delta.getResource();
                        if (!"as".equals(file.getFileExtension())) {
                            return true;
                        }
                        if (delta.getKind() == 4 && (delta.getFlags() & 0x100) != 0) {
                            fileChanged.add(file);
                        }
                    }
                    return true;
                }
            });
        }
        catch (CoreException coreException) {}
        return fileChanged;
    }
}

