/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vwcsdktools.model;

import com.vmware.vide.vwcsdktools.model.IPropertyChangedEvent;
import com.vmware.vide.vwcsdktools.model.IPropertyChangedListener;
import com.vmware.vide.vwcsdktools.model.PropertyChangedEvent;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;

public class ProxiedPreferenceStore
extends PreferenceStore {
    private final IResource resource;
    private final IPreferenceStore store;
    private final String ownerId;
    private boolean inserting;
    private final PropertyChangeEventManager eventManager;

    public ProxiedPreferenceStore(IResource resource, IPreferenceStore store, String ownerId) {
        this.resource = resource;
        this.store = store;
        this.ownerId = ownerId;
        this.eventManager = new PropertyChangeEventManager();
    }

    public String getDefaultString(String name) {
        return this.store.getDefaultString(name);
    }

    public String getString(String name) {
        this.insertValue(name);
        return super.getString(name);
    }

    private synchronized void insertValue(String name) {
        if (this.inserting) {
            return;
        }
        if (super.contains(name)) {
            return;
        }
        this.inserting = true;
        String property = null;
        try {
            property = this.getProperty(name);
        }
        catch (CoreException coreException) {}
        if (property == null) {
            property = this.store.getString(name);
        }
        if (property != null) {
            this.setValue(name, property);
        }
        this.inserting = false;
    }

    private String getProperty(String name) throws CoreException {
        return this.resource.getPersistentProperty(new QualifiedName(this.ownerId, name));
    }

    public boolean contains(String name) {
        return this.store.contains(name);
    }

    public void setToDefault(String name) {
        this.setValue(name, this.getDefaultString(name));
    }

    public boolean isDefault(String name) {
        String defaultValue = this.getDefaultString(name);
        if (defaultValue == null) {
            return false;
        }
        return defaultValue.equals(this.getString(name));
    }

    public void save() throws IOException {
        this.writeProperties();
    }

    public void save(OutputStream out, String header) throws IOException {
        this.writeProperties();
    }

    private void writeProperties() throws IOException {
        String[] preferences;
        String[] stringArray = preferences = super.preferenceNames();
        int n = preferences.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            try {
                this.setProperty(name, this.getString(name));
            }
            catch (CoreException e) {
                throw new IOException("Cannot write resource property " + name, e);
            }
            ++n2;
        }
    }

    private void setProperty(String name, String value) throws CoreException {
        QualifiedName key = new QualifiedName(this.ownerId, name);
        String oldValue = this.resource.getPersistentProperty(key);
        if (value.equals(oldValue)) {
            return;
        }
        this.resource.setPersistentProperty(key, value);
        PropertyChangedEvent event = new PropertyChangedEvent(key, value, oldValue, this.resource);
        this.eventManager.firePropertyChangedEvent(event);
    }

    public void addPropertyChangedListener(IPropertyChangedListener listener) {
        this.eventManager.addListener(listener);
    }

    public void removePropertyChangedListener(IPropertyChangedListener listener) {
        this.eventManager.removeListener(listener);
    }

    class PropertyChangeEventManager
    extends EventManager {
        PropertyChangeEventManager() {
        }

        void addListener(IPropertyChangedListener listener) {
            if (this.isListenerAttached()) {
                Object[] objectArray = this.getListeners();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    if (o instanceof IPropertyChangedListener && (IPropertyChangedListener)o == listener) {
                        return;
                    }
                    ++n2;
                }
            }
            super.addListenerObject((Object)listener);
        }

        void removeListener(IPropertyChangedListener listener) {
            super.removeListenerObject((Object)listener);
        }

        void firePropertyChangedEvent(IPropertyChangedEvent event) {
            Object[] objectArray = this.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o instanceof IPropertyChangedListener) {
                    ((IPropertyChangedListener)o).propertyChanged(event);
                }
                ++n2;
            }
        }
    }
}

